/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.audit.jpa;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.keycloak.Config;
import org.keycloak.audit.AuditProvider;
import org.keycloak.audit.AuditProviderFactory;
import org.keycloak.audit.EventType;
import org.keycloak.audit.jpa.JpaAuditProvider;
import org.keycloak.provider.ProviderSession;

public class JpaAuditProviderFactory
implements AuditProviderFactory {
    public static final String ID = "jpa";
    private EntityManagerFactory emf;
    private Set<EventType> includedEvents = new HashSet<EventType>();

    public AuditProvider create(ProviderSession providerSession) {
        return new JpaAuditProvider(this.emf.createEntityManager(), this.includedEvents);
    }

    /*
     * WARNING - void declaration
     */
    public void init(Config.Scope config) {
        String[] exclude;
        this.emf = Persistence.createEntityManagerFactory((String)"jpa-keycloak-audit-store");
        String[] include = config.getArray("include-events");
        if (include != null) {
            for (String string : include) {
                this.includedEvents.add(EventType.valueOf((String)string.toUpperCase()));
            }
        } else {
            for (String string : EventType.values()) {
                this.includedEvents.add((EventType)string);
            }
        }
        if ((exclude = config.getArray("exclude-events")) != null) {
            void var6_11;
            String[] arr$ = exclude;
            int len$ = arr$.length;
            boolean bl = false;
            while (var6_11 < len$) {
                String e = arr$[var6_11];
                this.includedEvents.remove(EventType.valueOf((String)e.toUpperCase()));
                ++var6_11;
            }
        }
    }

    public void close() {
        this.emf.close();
    }

    public String getId() {
        return ID;
    }
}

