/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.UnauthorizedException;
import org.keycloak.audit.Audit;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderSession;
import org.keycloak.services.ClientConnection;
import org.keycloak.services.managers.AuditManager;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.SocialRequestManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.AccountService;
import org.keycloak.services.resources.PublicRealmResource;
import org.keycloak.services.resources.TokenService;
import org.keycloak.util.StreamUtil;

@Path(value="/realms")
public class RealmsResource {
    protected static Logger logger = Logger.getLogger(RealmsResource.class);
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders headers;
    @Context
    protected KeycloakSession session;
    @Context
    protected ProviderSession providers;
    @Context
    protected ClientConnection clientConnection;
    @Context
    protected BruteForceProtector protector;
    protected TokenManager tokenManager;
    protected SocialRequestManager socialRequestManager;

    public RealmsResource(TokenManager tokenManager, SocialRequestManager socialRequestManager) {
        this.tokenManager = tokenManager;
        this.socialRequestManager = socialRequestManager;
    }

    public static UriBuilder realmBaseUrl(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(RealmsResource.class, "getRealmResource");
    }

    public static UriBuilder realmBaseUrl(UriBuilder base) {
        return base.path(RealmsResource.class).path(RealmsResource.class, "getRealmResource");
    }

    public static UriBuilder accountUrl(UriBuilder base) {
        return base.path(RealmsResource.class).path(RealmsResource.class, "getAccountService");
    }

    @Path(value="{realm}/login-status-iframe.html")
    @GET
    @Produces(value={"text/html"})
    @NoCache
    public String getLoginStatusIframe(@PathParam(value="realm") String name, @QueryParam(value="client_id") String client_id, @QueryParam(value="origin") String origin) {
        logger.info((Object)"getLoginStatusIframe");
        AuthenticationManager auth = new AuthenticationManager(this.providers);
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.locateRealm(name, realmManager);
        ClientModel client = realm.findClient(client_id);
        if (client == null) {
            throw new NotFoundException("could not find client: " + client_id);
        }
        AuthenticationManager.AuthResult result = auth.authenticateIdentityCookie(realm, this.uriInfo, this.headers);
        if (result == null) {
            throw new UnauthorizedException("not logged in, can't get page");
        }
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("login-status-iframe.html");
        if (is == null) {
            throw new NotFoundException("Could not find login-status-iframe.html ");
        }
        boolean valid = false;
        for (String o : client.getWebOrigins()) {
            if (!o.equals("*") && !o.equals(origin)) continue;
            valid = true;
            break;
        }
        for (String r : TokenService.resolveValidRedirects(this.uriInfo, client.getRedirectUris())) {
            int i = r.indexOf(47, 8);
            if (i != -1) {
                r = r.substring(0, i);
            }
            if (!r.equals(origin)) continue;
            valid = true;
            break;
        }
        if (!valid) {
            throw new BadRequestException("Invalid origin");
        }
        try {
            String file = StreamUtil.readString((InputStream)is);
            return file.replace("ORIGIN", origin);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Path(value="{realm}/tokens")
    public TokenService getTokenService(@PathParam(value="realm") String name) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.locateRealm(name, realmManager);
        Audit audit = new AuditManager(realm, this.providers, this.clientConnection).createAudit();
        AuthenticationManager authManager = new AuthenticationManager(this.providers, this.protector);
        TokenService tokenService = new TokenService(realm, this.tokenManager, audit, authManager);
        ResteasyProviderFactory.getInstance().injectProperties((Object)tokenService);
        return tokenService;
    }

    protected RealmModel locateRealm(String name, RealmManager realmManager) {
        RealmModel realm = realmManager.getRealmByName(name);
        if (realm == null) {
            throw new NotFoundException("Realm " + name + " does not exist");
        }
        return realm;
    }

    @Path(value="{realm}/account")
    public AccountService getAccountService(@PathParam(value="realm") String name) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.locateRealm(name, realmManager);
        ApplicationModel application = (ApplicationModel)realm.getApplicationNameMap().get("account");
        if (application == null || !application.isEnabled()) {
            logger.debug((Object)"account management not enabled");
            throw new NotFoundException("account management not enabled");
        }
        Audit audit = new AuditManager(realm, this.providers, this.clientConnection).createAudit();
        AccountService accountService = new AccountService(realm, application, this.tokenManager, this.socialRequestManager, audit);
        ResteasyProviderFactory.getInstance().injectProperties((Object)accountService);
        accountService.init();
        return accountService;
    }

    @Path(value="{realm}")
    public PublicRealmResource getRealmResource(@PathParam(value="realm") String name) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.locateRealm(name, realmManager);
        PublicRealmResource realmResource = new PublicRealmResource(realm);
        ResteasyProviderFactory.getInstance().injectProperties((Object)realmResource);
        return realmResource;
    }
}

