/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailProvider;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.provider.ProviderSession;
import org.keycloak.representations.adapters.action.UserStats;
import org.keycloak.representations.idm.ApplicationMappingsRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.MappingsRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.SocialLinkRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.keycloak.services.managers.AccessCodeEntry;
import org.keycloak.services.managers.ModelToRepresentation;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.ResourceAdminManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.services.resources.flows.Urls;
import org.keycloak.util.Time;

public class UsersResource {
    protected static final Logger logger = Logger.getLogger(UsersResource.class);
    protected RealmModel realm;
    private ProviderSession providerSession;
    private RealmAuth auth;
    private TokenManager tokenManager;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected KeycloakSession session;

    public UsersResource(ProviderSession providerSession, RealmModel realm, RealmAuth auth, TokenManager tokenManager) {
        this.providerSession = providerSession;
        this.auth = auth;
        this.realm = realm;
        this.tokenManager = tokenManager;
        auth.init(RealmAuth.Resource.USER);
    }

    @Path(value="{username}")
    @PUT
    @Consumes(value={"application/json"})
    public Response updateUser(@PathParam(value="username") String username, UserRepresentation rep) {
        this.auth.requireManage();
        try {
            UserModel user = this.realm.getUser(username);
            if (user == null) {
                throw new NotFoundException("User not found");
            }
            this.updateUserFromRep(user, rep);
            return Response.noContent().build();
        }
        catch (ModelDuplicateException e) {
            return Flows.errors().exists("User exists with same username or email");
        }
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createUser(@Context UriInfo uriInfo, UserRepresentation rep) {
        this.auth.requireManage();
        try {
            UserModel user = this.realm.addUser(rep.getUsername());
            this.updateUserFromRep(user, rep);
            return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(user.getLoginName()).build(new Object[0])).build();
        }
        catch (ModelDuplicateException e) {
            return Flows.errors().exists("User exists with same username or email");
        }
    }

    private void updateUserFromRep(UserModel user, UserRepresentation rep) {
        user.setEmail(rep.getEmail());
        user.setFirstName(rep.getFirstName());
        user.setLastName(rep.getLastName());
        user.setEnabled(rep.isEnabled());
        user.setTotp(rep.isTotp());
        user.setEmailVerified(rep.isEmailVerified());
        List reqActions = rep.getRequiredActions();
        if (reqActions != null) {
            for (UserModel.RequiredAction ra : UserModel.RequiredAction.values()) {
                if (reqActions.contains(ra.name())) {
                    user.addRequiredAction(ra);
                    continue;
                }
                user.removeRequiredAction(ra);
            }
        }
        if (rep.getAttributes() != null) {
            for (Map.Entry attr : rep.getAttributes().entrySet()) {
                user.setAttribute((String)attr.getKey(), (String)attr.getValue());
            }
        }
    }

    @Path(value="{username}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public UserRepresentation getUser(@PathParam(value="username") String username) {
        this.auth.requireView();
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        return ModelToRepresentation.toRepresentation(user);
    }

    @Path(value="{username}/session-stats")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Map<String, UserStats> getSessionStats(@PathParam(value="username") String username) {
        logger.info((Object)"session-stats");
        this.auth.requireView();
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        HashMap<String, UserStats> stats = new HashMap<String, UserStats>();
        for (ApplicationModel applicationModel : this.realm.getApplications()) {
            UserStats appStats;
            if (applicationModel.getManagementUrl() == null || (appStats = new ResourceAdminManager().getUserStats(this.uriInfo.getRequestUri(), this.realm, applicationModel, user)) == null || !appStats.isLoggedIn()) continue;
            stats.put(applicationModel.getName(), appStats);
        }
        return stats;
    }

    @Path(value="{username}/sessions")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<UserSessionRepresentation> getSessions(@PathParam(value="username") String username) {
        logger.info((Object)"sessions");
        this.auth.requireView();
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        List sessions = this.realm.getUserSessions(user);
        ArrayList<UserSessionRepresentation> reps = new ArrayList<UserSessionRepresentation>();
        for (UserSessionModel session : sessions) {
            UserSessionRepresentation rep = ModelToRepresentation.toRepresentation(session);
            reps.add(rep);
        }
        return reps;
    }

    @Path(value="{username}/social-links")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<SocialLinkRepresentation> getSocialLinks(@PathParam(value="username") String username) {
        this.auth.requireView();
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        Set socialLinks = this.realm.getSocialLinks(user);
        ArrayList<SocialLinkRepresentation> result = new ArrayList<SocialLinkRepresentation>();
        for (SocialLinkModel socialLink : socialLinks) {
            SocialLinkRepresentation rep = ModelToRepresentation.toRepresentation(socialLink);
            result.add(rep);
        }
        return result;
    }

    @Path(value="{username}/logout")
    @POST
    public void logout(@PathParam(value="username") String username) {
        this.auth.requireManage();
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        this.realm.removeUserSessions(user);
        user.setNotBefore(Time.currentTime());
        new ResourceAdminManager().logoutUser(this.uriInfo.getRequestUri(), this.realm, user.getId(), null);
    }

    @Path(value="{username}")
    @DELETE
    @NoCache
    public void deleteUser(@PathParam(value="username") String username) {
        this.auth.requireManage();
        this.realm.removeUser(username);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<UserRepresentation> getUsers(@QueryParam(value="search") String search, @QueryParam(value="lastName") String last, @QueryParam(value="firstName") String first, @QueryParam(value="email") String email, @QueryParam(value="username") String username) {
        List userModels;
        this.auth.requireView();
        RealmManager manager = new RealmManager(this.session);
        ArrayList<UserRepresentation> results = new ArrayList<UserRepresentation>();
        if (search != null) {
            userModels = manager.searchUsers(search, this.realm);
        } else if (last != null || first != null || email != null || username != null) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (last != null) {
                attributes.put("lastName", last);
            }
            if (first != null) {
                attributes.put("firstName", first);
            }
            if (email != null) {
                attributes.put("email", email);
            }
            if (username != null) {
                attributes.put("username", username);
            }
            userModels = this.realm.searchForUserByAttributes(attributes);
            for (UserModel user : userModels) {
                results.add(ModelToRepresentation.toRepresentation(user));
            }
        } else {
            userModels = this.realm.getUsers();
        }
        for (UserModel user : userModels) {
            results.add(ModelToRepresentation.toRepresentation(user));
        }
        return results;
    }

    @Path(value="{username}/role-mappings")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public MappingsRepresentation getRoleMappings(@PathParam(value="username") String username) {
        List applications;
        this.auth.requireView();
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        MappingsRepresentation all = new MappingsRepresentation();
        Set realmMappings = this.realm.getRoleMappings(user);
        RealmManager manager = new RealmManager(this.session);
        if (realmMappings.size() > 0) {
            ArrayList<RoleRepresentation> realmRep = new ArrayList<RoleRepresentation>();
            for (RoleModel roleModel : realmMappings) {
                realmRep.add(ModelToRepresentation.toRepresentation(roleModel));
            }
            all.setRealmMappings(realmRep);
        }
        if ((applications = this.realm.getApplications()).size() > 0) {
            HashMap<String, ApplicationMappingsRepresentation> appMappings = new HashMap<String, ApplicationMappingsRepresentation>();
            for (ApplicationModel application : applications) {
                Set roleMappings = application.getApplicationRoleMappings(user);
                if (roleMappings.size() <= 0) continue;
                ApplicationMappingsRepresentation mappings = new ApplicationMappingsRepresentation();
                mappings.setApplicationId(application.getId());
                mappings.setApplication(application.getName());
                ArrayList<RoleRepresentation> roles = new ArrayList<RoleRepresentation>();
                mappings.setMappings(roles);
                for (RoleModel role : roleMappings) {
                    roles.add(ModelToRepresentation.toRepresentation(role));
                }
                appMappings.put(application.getName(), mappings);
                all.setApplicationMappings(appMappings);
            }
        }
        return all;
    }

    @Path(value="{username}/role-mappings/realm")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getRealmRoleMappings(@PathParam(value="username") String username) {
        this.auth.requireView();
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        Set realmMappings = this.realm.getRealmRoleMappings(user);
        ArrayList<RoleRepresentation> realmMappingsRep = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : realmMappings) {
            realmMappingsRep.add(ModelToRepresentation.toRepresentation(roleModel));
        }
        return realmMappingsRep;
    }

    @Path(value="{username}/role-mappings/realm/composite")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getCompositeRealmRoleMappings(@PathParam(value="username") String username) {
        this.auth.requireView();
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        Set roles = this.realm.getRoles();
        ArrayList<RoleRepresentation> realmMappingsRep = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : roles) {
            if (!this.realm.hasRole(user, roleModel)) continue;
            realmMappingsRep.add(ModelToRepresentation.toRepresentation(roleModel));
        }
        return realmMappingsRep;
    }

    @Path(value="{username}/role-mappings/realm/available")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getAvailableRealmRoleMappings(@PathParam(value="username") String username) {
        this.auth.requireView();
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        Set available = this.realm.getRoles();
        return this.getAvailableRoles(user, available);
    }

    @Path(value="{username}/role-mappings/realm")
    @POST
    @Consumes(value={"application/json"})
    public void addRealmRoleMappings(@PathParam(value="username") String username, List<RoleRepresentation> roles) {
        this.auth.requireManage();
        logger.debugv("** addRealmRoleMappings: {0}", roles);
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        for (RoleRepresentation role : roles) {
            RoleModel roleModel = this.realm.getRole(role.getName());
            if (roleModel == null || !roleModel.getId().equals(role.getId())) {
                throw new NotFoundException("Role not found");
            }
            this.realm.grantRole(user, roleModel);
        }
    }

    @Path(value="{username}/role-mappings/realm")
    @DELETE
    @Consumes(value={"application/json"})
    public void deleteRealmRoleMappings(@PathParam(value="username") String username, List<RoleRepresentation> roles) {
        this.auth.requireManage();
        logger.debug((Object)"deleteRealmRoleMappings");
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        if (roles == null) {
            Set roleModels = this.realm.getRealmRoleMappings(user);
            for (RoleModel roleModel : roleModels) {
                this.realm.deleteRoleMapping(user, roleModel);
            }
        } else {
            for (RoleRepresentation role : roles) {
                RoleModel roleModel = this.realm.getRole(role.getName());
                if (roleModel == null || !roleModel.getId().equals(role.getId())) {
                    throw new NotFoundException("Role not found");
                }
                this.realm.deleteRoleMapping(user, roleModel);
            }
        }
    }

    @Path(value="{username}/role-mappings/applications/{app}")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getApplicationRoleMappings(@PathParam(value="username") String username, @PathParam(value="app") String appName) {
        this.auth.requireView();
        logger.debug((Object)"getApplicationRoleMappings");
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        ApplicationModel application = this.realm.getApplicationByName(appName);
        if (application == null) {
            throw new NotFoundException("Application not found");
        }
        Set mappings = application.getApplicationRoleMappings(user);
        ArrayList<RoleRepresentation> mapRep = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : mappings) {
            mapRep.add(ModelToRepresentation.toRepresentation(roleModel));
        }
        logger.debugv("getApplicationRoleMappings.size() = {0}", (Object)mapRep.size());
        return mapRep;
    }

    @Path(value="{username}/role-mappings/applications/{app}/composite")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getCompositeApplicationRoleMappings(@PathParam(value="username") String username, @PathParam(value="app") String appName) {
        this.auth.requireView();
        logger.debug((Object)"getCompositeApplicationRoleMappings");
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        ApplicationModel application = this.realm.getApplicationByName(appName);
        if (application == null) {
            throw new NotFoundException("Application not found");
        }
        Set roles = application.getRoles();
        ArrayList<RoleRepresentation> mapRep = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : roles) {
            if (!this.realm.hasRole(user, roleModel)) continue;
            mapRep.add(ModelToRepresentation.toRepresentation(roleModel));
        }
        logger.debugv("getCompositeApplicationRoleMappings.size() = {0}", (Object)mapRep.size());
        return mapRep;
    }

    @Path(value="{username}/role-mappings/applications/{app}/available")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getAvailableApplicationRoleMappings(@PathParam(value="username") String username, @PathParam(value="app") String appName) {
        this.auth.requireView();
        logger.debug((Object)"getApplicationRoleMappings");
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        ApplicationModel application = this.realm.getApplicationByName(appName);
        if (application == null) {
            throw new NotFoundException("Application not found");
        }
        Set available = application.getRoles();
        return this.getAvailableRoles(user, available);
    }

    protected List<RoleRepresentation> getAvailableRoles(UserModel user, Set<RoleModel> available) {
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (RoleModel roleModel : available) {
            if (this.realm.hasRole(user, roleModel)) continue;
            roles.add(roleModel);
        }
        ArrayList<RoleRepresentation> mappings = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : roles) {
            mappings.add(ModelToRepresentation.toRepresentation(roleModel));
        }
        return mappings;
    }

    @Path(value="{username}/role-mappings/applications/{app}")
    @POST
    @Consumes(value={"application/json"})
    public void addApplicationRoleMapping(@PathParam(value="username") String username, @PathParam(value="app") String appName, List<RoleRepresentation> roles) {
        this.auth.requireManage();
        logger.debug((Object)"addApplicationRoleMapping");
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        ApplicationModel application = this.realm.getApplicationByName(appName);
        if (application == null) {
            throw new NotFoundException("Application not found");
        }
        for (RoleRepresentation role : roles) {
            RoleModel roleModel = application.getRole(role.getName());
            if (roleModel == null || !roleModel.getId().equals(role.getId())) {
                throw new NotFoundException("Role not found");
            }
            this.realm.grantRole(user, roleModel);
        }
    }

    @Path(value="{username}/role-mappings/applications/{app}")
    @DELETE
    @Consumes(value={"application/json"})
    public void deleteApplicationRoleMapping(@PathParam(value="username") String username, @PathParam(value="app") String appName, List<RoleRepresentation> roles) {
        this.auth.requireManage();
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        ApplicationModel application = this.realm.getApplicationByName(appName);
        if (application == null) {
            throw new NotFoundException("Application not found");
        }
        if (roles == null) {
            Set roleModels = application.getApplicationRoleMappings(user);
            for (RoleModel roleModel : roleModels) {
                ApplicationModel app;
                if (!(roleModel.getContainer() instanceof ApplicationModel) && !(app = (ApplicationModel)roleModel.getContainer()).getId().equals(application.getId())) continue;
                this.realm.deleteRoleMapping(user, roleModel);
            }
        } else {
            for (RoleRepresentation role : roles) {
                RoleModel roleModel = application.getRole(role.getName());
                if (roleModel == null || !roleModel.getId().equals(role.getId())) {
                    throw new NotFoundException("Role not found");
                }
                this.realm.deleteRoleMapping(user, roleModel);
            }
        }
    }

    @Path(value="{username}/reset-password")
    @PUT
    @Consumes(value={"application/json"})
    public void resetPassword(@PathParam(value="username") String username, CredentialRepresentation pass) {
        this.auth.requireManage();
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        if (pass == null || pass.getValue() == null || !"password".equals(pass.getType())) {
            throw new BadRequestException("No password provided");
        }
        UserCredentialModel cred = RealmManager.fromRepresentation(pass);
        this.realm.updateCredential(user, cred);
        user.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
    }

    @Path(value="{username}/remove-totp")
    @PUT
    @Consumes(value={"application/json"})
    public void removeTotp(@PathParam(value="username") String username) {
        this.auth.requireManage();
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        user.setTotp(false);
    }

    @Path(value="{username}/reset-password-email")
    @PUT
    @Consumes(value={"application/json"})
    public Response resetPasswordEmail(@PathParam(value="username") String username) {
        this.auth.requireManage();
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        if (user.getEmail() == null) {
            return Flows.errors().error("User email missing", Response.Status.BAD_REQUEST);
        }
        String redirect = Urls.accountBase(this.uriInfo.getBaseUri()).path("/").build(new Object[]{this.realm.getName()}).toString();
        String clientId = "account";
        String state = null;
        String scope = null;
        ClientModel client = this.realm.findClient(clientId);
        if (client == null || !client.isEnabled()) {
            return Flows.errors().error("AccountProvider management not enabled", Response.Status.INTERNAL_SERVER_ERROR);
        }
        HashSet<UserModel.RequiredAction> requiredActions = new HashSet<UserModel.RequiredAction>(user.getRequiredActions());
        requiredActions.add(UserModel.RequiredAction.UPDATE_PASSWORD);
        AccessCodeEntry accessCode = this.tokenManager.createAccessCode(scope, state, redirect, this.realm, client, user, null);
        accessCode.setRequiredActions(requiredActions);
        accessCode.setExpiration(Time.currentTime() + this.realm.getAccessCodeLifespanUserAction());
        try {
            UriBuilder builder = Urls.loginPasswordResetBuilder(this.uriInfo.getBaseUri());
            builder.queryParam("key", new Object[]{accessCode.getId()});
            String link = builder.build(new Object[]{this.realm.getName()}).toString();
            long expiration = TimeUnit.SECONDS.toMinutes(this.realm.getAccessCodeLifespanUserAction());
            ((EmailProvider)this.providerSession.getProvider(EmailProvider.class)).setRealm(this.realm).setUser(user).sendPasswordReset(link, expiration);
            return Response.ok().build();
        }
        catch (EmailException e) {
            logger.error((Object)"Failed to send password reset email", (Throwable)e);
            return Flows.errors().error("Failed to send email", Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

