/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.audit.log;

import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.audit.AuditListener;
import org.keycloak.audit.Event;

public class JBossLoggingAuditListener
implements AuditListener {
    private final Logger logger;

    public JBossLoggingAuditListener(Logger logger) {
        this.logger = logger;
    }

    public void onEvent(Event event) {
        Logger.Level level;
        Logger.Level level2 = level = event.getError() != null ? Logger.Level.WARN : Logger.Level.INFO;
        if (this.logger.isEnabled(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append("event=");
            sb.append(event.getEvent());
            sb.append(", realmId=");
            sb.append(event.getRealmId());
            sb.append(", clientId=");
            sb.append(event.getClientId());
            sb.append(", userId=");
            sb.append(event.getUserId());
            sb.append(", ipAddress=");
            sb.append(event.getIpAddress());
            if (event.getError() != null) {
                sb.append(", error=");
                sb.append(event.getError());
            }
            if (event.getDetails() != null) {
                for (Map.Entry e : event.getDetails().entrySet()) {
                    sb.append(", ");
                    sb.append((String)e.getKey());
                    if (e.getValue() == null || ((String)e.getValue()).indexOf(32) == -1) {
                        sb.append("=");
                        sb.append((String)e.getValue());
                        continue;
                    }
                    sb.append("='");
                    sb.append((String)e.getValue());
                    sb.append("'");
                }
            }
            this.logger.log(level, (Object)sb.toString());
        }
    }

    public void close() {
    }
}

