/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.keycloak.freemarker.Theme;
import org.keycloak.freemarker.ThemeProvider;
import org.keycloak.theme.FolderTheme;

public class FolderThemeProvider
implements ThemeProvider {
    private File rootDir;

    public FolderThemeProvider(File rootDir) {
        this.rootDir = rootDir;
    }

    public int getProviderPriority() {
        return 100;
    }

    public Theme createTheme(String name, Theme.Type type) throws IOException {
        if (this.hasTheme(name, type)) {
            return new FolderTheme(new File(this.getTypeDir(type), name), type);
        }
        return null;
    }

    public Set<String> nameSet(Theme.Type type) {
        File typeDir = this.getTypeDir(type);
        if (typeDir != null) {
            File[] themes = typeDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            });
            HashSet<String> names = new HashSet<String>();
            for (File t : themes) {
                names.add(t.getName());
            }
            return names;
        }
        return Collections.emptySet();
    }

    private File getTypeDir(Theme.Type type) {
        File typeDir;
        if (this.rootDir != null && this.rootDir.isDirectory() && (typeDir = new File(this.rootDir, type.name().toLowerCase())).isDirectory()) {
            return typeDir;
        }
        return null;
    }

    public boolean hasTheme(String name, Theme.Type type) {
        File typeDir = this.getTypeDir(type);
        return typeDir != null && new File(typeDir, name).isDirectory();
    }

    public void close() {
    }
}

