/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.logging.Logger;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.Config;
import org.keycloak.SkeletonKeyContextResolver;
import org.keycloak.exportimport.ExportImportProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderSession;
import org.keycloak.provider.ProviderSessionFactory;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.DefaultProviderSessionFactory;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.JsResource;
import org.keycloak.services.resources.QRCodeResource;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.SocialResource;
import org.keycloak.services.resources.ThemeResource;
import org.keycloak.services.resources.WelcomeResource;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.scheduled.ClearExpiredAuditEvents;
import org.keycloak.services.scheduled.ClearExpiredUserSessions;
import org.keycloak.services.scheduled.ScheduledTaskRunner;
import org.keycloak.services.util.JsonConfigProvider;
import org.keycloak.timer.TimerProvider;
import org.keycloak.util.JsonSerialization;
import org.keycloak.util.ProviderLoader;

public class KeycloakApplication
extends Application {
    private static final Logger log = Logger.getLogger(KeycloakApplication.class);
    protected Set<Object> singletons = new HashSet<Object>();
    protected Set<Class<?>> classes = new HashSet();
    protected ProviderSessionFactory providerSessionFactory;
    protected String contextPath;

    public KeycloakApplication(@Context ServletContext context, @Context Dispatcher dispatcher) {
        this.loadConfig();
        this.providerSessionFactory = KeycloakApplication.createProviderSessionFactory();
        dispatcher.getDefaultContextObjects().put(KeycloakApplication.class, this);
        this.contextPath = context.getContextPath();
        BruteForceProtector protector = new BruteForceProtector(this.providerSessionFactory);
        dispatcher.getDefaultContextObjects().put(BruteForceProtector.class, protector);
        ResteasyProviderFactory.pushContext(BruteForceProtector.class, (Object)protector);
        protector.start();
        context.setAttribute(BruteForceProtector.class.getName(), (Object)protector);
        context.setAttribute(ProviderSessionFactory.class.getName(), (Object)this.providerSessionFactory);
        TokenManager tokenManager = new TokenManager();
        this.singletons.add(new RealmsResource(tokenManager));
        this.singletons.add(new SocialResource(tokenManager));
        this.singletons.add(new AdminRoot(tokenManager));
        this.classes.add(SkeletonKeyContextResolver.class);
        this.classes.add(QRCodeResource.class);
        this.classes.add(ThemeResource.class);
        this.classes.add(JsResource.class);
        this.classes.add(WelcomeResource.class);
        this.checkExportImportProvider();
        this.setupDefaultRealm(context.getContextPath());
        KeycloakApplication.setupScheduledTasks(this.providerSessionFactory);
        this.importRealms(context);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public URI getBaseUri(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().replacePath(this.getContextPath()).build(new Object[0]);
    }

    protected void loadConfig() {
        try {
            File f;
            URL config = null;
            String configDir = System.getProperty("jboss.server.config.dir");
            if (configDir != null && (f = new File(configDir + File.separator + "keycloak-server.json")).isFile()) {
                config = f.toURI().toURL();
            }
            if (config == null) {
                config = Thread.currentThread().getContextClassLoader().getResource("META-INF/keycloak-server.json");
            }
            if (config != null) {
                JsonNode node = new ObjectMapper().readTree(config);
                Config.init((Config.ConfigProvider)new JsonConfigProvider(node));
                log.info((Object)("Loaded config from " + config));
                return;
            }
            log.warn((Object)"Config 'keycloak-server.json' not found");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load config", e);
        }
    }

    protected void setupDefaultRealm(String contextPath) {
        new ApplianceBootstrap().bootstrap(this.providerSessionFactory, contextPath);
    }

    public static DefaultProviderSessionFactory createProviderSessionFactory() {
        DefaultProviderSessionFactory factory = new DefaultProviderSessionFactory();
        factory.init();
        return factory;
    }

    public static void setupScheduledTasks(ProviderSessionFactory providerSessionFactory) {
        long interval = Config.scope((String[])new String[]{"scheduled"}).getLong("interval", Long.valueOf(60L)) * 1000L;
        TimerProvider timer = (TimerProvider)providerSessionFactory.createSession().getProvider(TimerProvider.class);
        timer.schedule((Runnable)new ScheduledTaskRunner(providerSessionFactory, new ClearExpiredAuditEvents()), interval);
        timer.schedule((Runnable)new ScheduledTaskRunner(providerSessionFactory, new ClearExpiredUserSessions()), interval);
    }

    public ProviderSessionFactory getProviderSessionFactory() {
        return this.providerSessionFactory;
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }

    public void importRealms(ServletContext context) {
        this.importRealmFile();
        this.importRealmResources(context);
    }

    public void importRealmResources(ServletContext context) {
        String resources = context.getInitParameter("keycloak.import.realm.resources");
        if (resources != null) {
            StringTokenizer tokenizer = new StringTokenizer(resources, ",");
            while (tokenizer.hasMoreTokens()) {
                String resource = tokenizer.nextToken().trim();
                InputStream is = context.getResourceAsStream(resource);
                if (is == null) {
                    log.warn((Object)("Could not find realm resource to import: " + resource));
                }
                RealmRepresentation rep = KeycloakApplication.loadJson(is, RealmRepresentation.class);
                this.importRealm(rep, "resource " + resource);
            }
        }
    }

    public void importRealmFile() {
        String file = System.getProperty("keycloak.import");
        if (file != null) {
            RealmRepresentation rep = null;
            try {
                rep = KeycloakApplication.loadJson(new FileInputStream(file), RealmRepresentation.class);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            this.importRealm(rep, "file " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importRealm(RealmRepresentation rep, String from) {
        ProviderSession providerSession = this.providerSessionFactory.createSession();
        KeycloakSession session = (KeycloakSession)providerSession.getProvider(KeycloakSession.class);
        try {
            session.getTransaction().begin();
            RealmManager manager = new RealmManager(session);
            manager.setContextPath(this.getContextPath());
            if (rep.getId() != null && manager.getRealm(rep.getId()) != null) {
                log.info((Object)("Not importing realm " + rep.getRealm() + " from " + from + ".  It already exists."));
                return;
            }
            if (manager.getRealmByName(rep.getRealm()) != null) {
                log.info((Object)("Not importing realm " + rep.getRealm() + " from " + from + ".  It already exists."));
                return;
            }
            RealmModel realm = manager.createRealm(rep.getId(), rep.getRealm());
            manager.importRealm(rep, realm);
            log.info((Object)("Imported realm " + realm.getName() + " from " + from));
            session.getTransaction().commit();
        }
        finally {
            providerSession.close();
        }
    }

    private static <T> T loadJson(InputStream is, Class<T> type) {
        try {
            return (T)JsonSerialization.readValue((InputStream)is, type);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse json", e);
        }
    }

    protected void checkExportImportProvider() {
        Iterator providers = ProviderLoader.load(ExportImportProvider.class).iterator();
        if (providers.hasNext()) {
            ExportImportProvider exportImport = (ExportImportProvider)providers.next();
            exportImport.checkExportImport(this.providerSessionFactory);
        } else {
            log.warn((Object)"No ExportImportProvider found!");
        }
    }
}

