/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/")
public class WelcomeResource {
    @Context
    private UriInfo uriInfo;

    @GET
    @Produces(value={"text/html"})
    public Response getWelcomePage() throws URISyntaxException {
        String requestUri = this.uriInfo.getRequestUri().toString();
        if (!requestUri.endsWith("/")) {
            return Response.seeOther((URI)new URI(requestUri + "/")).build();
        }
        return this.getResource("index.html");
    }

    @GET
    @Path(value="/welcome-content/{name}")
    @Produces(value={"text/html"})
    public Response getResource(@PathParam(value="name") String name) {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("welcome-content/" + name);
        if (inputStream != null) {
            return Response.ok((Object)inputStream).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

