/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.codehaus.jackson.annotate.JsonProperty;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.freemarker.ExtendingThemeManager;
import org.keycloak.freemarker.Theme;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderSession;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.ApplicationManager;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.services.resources.TokenService;
import org.keycloak.services.resources.admin.AdminRoot;

public class AdminConsole {
    protected static final Logger logger = Logger.getLogger(AdminConsole.class);
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpRequest request;
    @Context
    protected HttpResponse response;
    @Context
    protected KeycloakSession session;
    @Context
    protected Providers providers;
    @Context
    protected ProviderSession providerSession;
    @Context
    protected KeycloakApplication keycloak;
    protected AppAuthManager authManager;
    protected RealmModel realm;
    private static FileTypeMap mimeTypes = MimetypesFileTypeMap.getDefaultFileTypeMap();

    public AdminConsole(RealmModel realm) {
        this.realm = realm;
        this.authManager = new AppAuthManager(this.providerSession);
    }

    @Path(value="config")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public ApplicationManager.InstallationAdapterConfig config() {
        ApplicationModel consoleApp = this.realm.getApplicationByName("security-admin-console");
        if (consoleApp == null) {
            throw new NotFoundException("Could not find admin console application");
        }
        return new ApplicationManager().toInstallationRepresentation(this.realm, consoleApp, this.keycloak.getBaseUri(this.uriInfo));
    }

    @Path(value="whoami")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response whoAmI(@Context HttpHeaders headers) {
        String displayName;
        RealmManager realmManager = new RealmManager(this.session);
        AuthenticationManager.AuthResult authResult = this.authManager.authenticateBearerToken(this.realm, this.uriInfo, headers);
        if (authResult == null) {
            return Response.status((int)401).build();
        }
        UserModel user = authResult.getUser();
        if (user.getFirstName() != null && !user.getFirstName().trim().equals("") || user.getLastName() != null && !user.getLastName().trim().equals("")) {
            displayName = user.getFirstName();
            if (user.getLastName() != null) {
                displayName = displayName != null ? displayName + " " + user.getLastName() : user.getLastName();
            }
        } else {
            displayName = user.getLoginName();
        }
        RealmModel masterRealm = this.getAdminstrationRealm(realmManager);
        HashMap<String, Set<String>> realmAccess = new HashMap<String, Set<String>>();
        if (masterRealm == null) {
            throw new NotFoundException("No realm found");
        }
        boolean createRealm = false;
        if (this.realm.equals(masterRealm)) {
            logger.info((Object)"setting up realm access for a master realm user");
            createRealm = user.hasRole(masterRealm.getRole(AdminRoles.CREATE_REALM));
            this.addMasterRealmAccess(this.realm, user, realmAccess);
        } else {
            logger.info((Object)"setting up realm access for a realm user");
            this.addRealmAccess(this.realm, user, realmAccess);
        }
        if (realmAccess.size() == 0) {
            return Response.status((int)401).build();
        }
        return Response.ok((Object)new WhoAmI(user.getId(), this.realm.getName(), displayName, createRealm, realmAccess)).build();
    }

    private void addRealmAccess(RealmModel realm, UserModel user, Map<String, Set<String>> realmAdminAccess) {
        RealmManager realmManager = new RealmManager(this.session);
        ApplicationModel realmAdminApp = realm.getApplicationByName(realmManager.getRealmAdminApplicationName(realm));
        Set roles = realmAdminApp.getRoles();
        for (RoleModel role : roles) {
            if (!user.hasRole(role)) continue;
            if (!realmAdminAccess.containsKey(realm.getName())) {
                realmAdminAccess.put(realm.getName(), new HashSet());
            }
            realmAdminAccess.get(realm.getName()).add(role.getName());
        }
    }

    private void addMasterRealmAccess(RealmModel masterRealm, UserModel user, Map<String, Set<String>> realmAdminAccess) {
        List realms = this.session.getRealms();
        for (RealmModel realm : realms) {
            ApplicationModel realmAdminApp = realm.getMasterAdminApp();
            Set roles = realmAdminApp.getRoles();
            for (RoleModel role : roles) {
                if (!user.hasRole(role)) continue;
                if (!realmAdminAccess.containsKey(realm.getName())) {
                    realmAdminAccess.put(realm.getName(), new HashSet());
                }
                realmAdminAccess.get(realm.getName()).add(role.getName());
            }
        }
    }

    @Path(value="logout")
    @GET
    @NoCache
    public Response logout() {
        URI redirect = AdminRoot.adminConsoleUrl(this.uriInfo).path("index.html").build(new Object[]{this.realm.getName()});
        return Response.status((int)302).location(TokenService.logoutUrl(this.uriInfo).queryParam("redirect_uri", new Object[]{redirect.toString()}).build(new Object[]{this.realm.getName()})).build();
    }

    protected RealmModel getAdminstrationRealm(RealmManager realmManager) {
        return realmManager.getKeycloakAdminstrationRealm();
    }

    @GET
    public Response getMainPage() throws URISyntaxException {
        if (!this.uriInfo.getRequestUri().getPath().endsWith("/")) {
            return Response.status((int)302).location(this.uriInfo.getRequestUriBuilder().path("/").build(new Object[0])).build();
        }
        return this.getResource("index.html");
    }

    @GET
    @Path(value="js/keycloak.js")
    @Produces(value={"text/javascript"})
    public Response getKeycloakJs() {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("keycloak.js");
        if (inputStream != null) {
            return Response.ok((Object)inputStream).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="{path:.+}")
    public Response getResource(@PathParam(value="path") String path) {
        if (path.equals("js/keycloak.js")) {
            return this.getKeycloakJs();
        }
        try {
            ExtendingThemeManager themeManager = new ExtendingThemeManager(this.providerSession);
            Theme theme = themeManager.createTheme(this.realm.getAdminTheme(), Theme.Type.ADMIN);
            InputStream resource = theme.getResourceAsStream(path);
            if (resource != null) {
                String contentType = mimeTypes.getContentType(path);
                CacheControl cacheControl = new CacheControl();
                cacheControl.setNoTransform(false);
                cacheControl.setMaxAge(themeManager.getStaticMaxAge());
                return Response.ok((Object)resource).type(contentType).cacheControl(cacheControl).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to get theme resource", (Throwable)e);
            return Response.serverError().build();
        }
    }

    public static class WhoAmI {
        protected String userId;
        protected String realm;
        protected String displayName;
        @JsonProperty(value="createRealm")
        protected boolean createRealm;
        @JsonProperty(value="realm_access")
        protected Map<String, Set<String>> realmAccess = new HashMap<String, Set<String>>();

        public WhoAmI() {
        }

        public WhoAmI(String userId, String realm, String displayName, boolean createRealm, Map<String, Set<String>> realmAccess) {
            this.userId = userId;
            this.realm = realm;
            this.displayName = displayName;
            this.createRealm = createRealm;
            this.realmAccess = realmAccess;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getRealm() {
            return this.realm;
        }

        public void setRealm(String realm) {
            this.realm = realm;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public boolean isCreateRealm() {
            return this.createRealm;
        }

        public void setCreateRealm(boolean createRealm) {
            this.createRealm = createRealm;
        }

        public Map<String, Set<String>> getRealmAccess() {
            return this.realmAccess;
        }

        public void setRealmAccess(Map<String, Set<String>> realmAccess) {
            this.realmAccess = realmAccess;
        }
    }
}

