/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.ApplicationRepresentation;
import org.keycloak.services.managers.ApplicationManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.admin.ApplicationResource;
import org.keycloak.services.resources.admin.RealmAdminResource;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.services.resources.flows.Flows;

public class ApplicationsResource {
    protected static final Logger logger = Logger.getLogger(RealmAdminResource.class);
    protected RealmModel realm;
    private RealmAuth auth;
    @Context
    protected KeycloakSession session;

    public ApplicationsResource(RealmModel realm, RealmAuth auth) {
        this.realm = realm;
        this.auth = auth;
        auth.init(RealmAuth.Resource.APPLICATION);
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<ApplicationRepresentation> getApplications() {
        this.auth.requireAny();
        ArrayList<ApplicationRepresentation> rep = new ArrayList<ApplicationRepresentation>();
        List applicationModels = this.realm.getApplications();
        ApplicationManager resourceManager = new ApplicationManager(new RealmManager(this.session));
        boolean view = this.auth.hasView();
        for (ApplicationModel applicationModel : applicationModels) {
            if (view) {
                rep.add(resourceManager.toRepresentation(applicationModel));
                continue;
            }
            ApplicationRepresentation app = new ApplicationRepresentation();
            app.setName(applicationModel.getName());
            rep.add(app);
        }
        return rep;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createApplication(@Context UriInfo uriInfo, ApplicationRepresentation rep) {
        this.auth.requireManage();
        ApplicationManager resourceManager = new ApplicationManager(new RealmManager(this.session));
        try {
            ApplicationModel applicationModel = resourceManager.createApplication(this.realm, rep);
            return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(applicationModel.getName()).build(new Object[0])).build();
        }
        catch (ModelDuplicateException e) {
            return Flows.errors().exists("Application " + rep.getName() + " already exists");
        }
    }

    @Path(value="{app-name}")
    public ApplicationResource getApplication(@PathParam(value="app-name") String name) {
        ApplicationModel applicationModel = this.realm.getApplicationByName(name);
        if (applicationModel == null) {
            throw new NotFoundException("Could not find application: " + name);
        }
        ApplicationResource applicationResource = new ApplicationResource(this.realm, this.auth, applicationModel, this.session);
        ResteasyProviderFactory.getInstance().injectProperties((Object)applicationResource);
        return applicationResource;
    }
}

