/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.io.directory;

import java.io.File;
import org.keycloak.exportimport.ExportImportConfig;
import org.keycloak.exportimport.io.ExportImportIOProvider;
import org.keycloak.exportimport.io.ExportWriter;
import org.keycloak.exportimport.io.ImportReader;
import org.keycloak.exportimport.io.directory.TmpDirExportWriter;
import org.keycloak.exportimport.io.directory.TmpDirImportReader;

public class TmpDirExportImportIOProvider
implements ExportImportIOProvider {
    public static final String PROVIDER_ID = "dir";

    @Override
    public ExportWriter getExportWriter() {
        String dir = ExportImportConfig.getDir();
        return dir != null ? new TmpDirExportWriter(new File(dir)) : new TmpDirExportWriter();
    }

    @Override
    public ImportReader getImportReader() {
        String dir = ExportImportConfig.getDir();
        return dir != null ? new TmpDirImportReader(new File(dir)) : new TmpDirImportReader();
    }

    @Override
    public String getId() {
        return PROVIDER_ID;
    }
}

