/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.impl;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.logging.Logger;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.mongo.api.MongoCollection;
import org.keycloak.models.mongo.api.MongoIdentifiableEntity;
import org.keycloak.models.mongo.api.MongoIndex;
import org.keycloak.models.mongo.api.MongoIndexes;
import org.keycloak.models.mongo.api.MongoStore;
import org.keycloak.models.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.mongo.api.context.MongoTask;
import org.keycloak.models.mongo.api.types.Mapper;
import org.keycloak.models.mongo.api.types.MapperContext;
import org.keycloak.models.mongo.api.types.MapperRegistry;
import org.keycloak.models.mongo.impl.EntityInfo;
import org.keycloak.models.mongo.impl.types.BasicDBListMapper;
import org.keycloak.models.mongo.impl.types.BasicDBObjectMapper;
import org.keycloak.models.mongo.impl.types.BasicDBObjectToMapMapper;
import org.keycloak.models.mongo.impl.types.EnumToStringMapper;
import org.keycloak.models.mongo.impl.types.ListMapper;
import org.keycloak.models.mongo.impl.types.MapMapper;
import org.keycloak.models.mongo.impl.types.MongoEntityMapper;
import org.keycloak.models.mongo.impl.types.SimpleMapper;
import org.keycloak.models.mongo.impl.types.StringToEnumMapper;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.reflection.Property;
import org.keycloak.models.utils.reflection.PropertyQueries;

public class MongoStoreImpl
implements MongoStore {
    private static final Class<?>[] SIMPLE_TYPES = new Class[]{String.class, Integer.class, Boolean.class, Long.class, Double.class, Character.class, Date.class, byte[].class};
    private final DB database;
    private static final Logger logger = Logger.getLogger(MongoStoreImpl.class);
    private final MapperRegistry mapperRegistry;
    private ConcurrentMap<Class<?>, EntityInfo> entityInfoCache = new ConcurrentHashMap();

    public MongoStoreImpl(DB database, boolean clearCollectionsOnStartup, Class<?>[] managedEntityTypes) {
        this.database = database;
        this.mapperRegistry = new MapperRegistry();
        for (Class<?> simpleMapperClass : SIMPLE_TYPES) {
            SimpleMapper mapper = new SimpleMapper(simpleMapperClass);
            this.mapperRegistry.addAppObjectMapper(mapper);
            this.mapperRegistry.addDBObjectMapper(mapper);
        }
        this.mapperRegistry.addAppObjectMapper(new ListMapper<ArrayList>(this.mapperRegistry, ArrayList.class));
        this.mapperRegistry.addAppObjectMapper(new ListMapper<List>(this.mapperRegistry, List.class));
        this.mapperRegistry.addDBObjectMapper(new BasicDBListMapper(this.mapperRegistry));
        this.mapperRegistry.addAppObjectMapper(new MapMapper<HashMap>(HashMap.class));
        this.mapperRegistry.addAppObjectMapper(new MapMapper<Map>(Map.class));
        this.mapperRegistry.addDBObjectMapper(new BasicDBObjectToMapMapper());
        this.mapperRegistry.addAppObjectMapper(new EnumToStringMapper());
        this.mapperRegistry.addDBObjectMapper(new StringToEnumMapper());
        for (Class<?> type : managedEntityTypes) {
            this.getEntityInfo(type);
            this.mapperRegistry.addAppObjectMapper(new MongoEntityMapper(this, this.mapperRegistry, type));
            this.mapperRegistry.addDBObjectMapper(new BasicDBObjectMapper(this, this.mapperRegistry, type));
        }
        if (clearCollectionsOnStartup) {
            this.clearManagedCollections(managedEntityTypes);
        }
        this.initManagedCollections(managedEntityTypes);
    }

    protected void dropDatabase() {
        this.database.dropDatabase();
        logger.info((Object)("Database " + this.database.getName() + " dropped in MongoDB"));
    }

    protected void clearManagedCollections(Class<?>[] managedEntityTypes) {
        for (Class<?> clazz : managedEntityTypes) {
            DBCollection dbCollection = this.getDBCollectionForType(clazz);
            if (dbCollection == null) continue;
            dbCollection.remove((DBObject)new BasicDBObject());
            logger.debug((Object)("Collection " + dbCollection.getName() + " cleared from " + this.database.getName()));
        }
    }

    protected void initManagedCollections(Class<?>[] managedEntityTypes) {
        for (Class<?> clazz : managedEntityTypes) {
            MongoIndexes indexes;
            EntityInfo entityInfo = this.getEntityInfo(clazz);
            String dbCollectionName = entityInfo.getDbCollectionName();
            if (dbCollectionName == null || this.database.collectionExists(dbCollectionName)) continue;
            DBCollection dbCollection = this.database.getCollection(dbCollectionName);
            logger.debug((Object)("Created collection " + dbCollection.getName() + " in " + this.database.getName()));
            MongoIndex index = clazz.getAnnotation(MongoIndex.class);
            if (index != null) {
                this.createIndex(dbCollection, index);
            }
            if ((indexes = clazz.getAnnotation(MongoIndexes.class)) == null) continue;
            for (MongoIndex i : indexes.value()) {
                this.createIndex(dbCollection, i);
            }
        }
    }

    protected void createIndex(DBCollection dbCollection, MongoIndex index) {
        BasicDBObject fields = new BasicDBObject();
        for (String f : index.fields()) {
            fields.put(f, (Object)1);
        }
        boolean unique = index.unique();
        boolean sparse = index.sparse();
        BasicDBObject options = new BasicDBObject();
        if (unique) {
            options.put("unique", (Object)unique);
        }
        if (sparse) {
            options.put("sparse", (Object)sparse);
        }
        dbCollection.ensureIndex((DBObject)fields, (DBObject)options);
        logger.debug((Object)("Created index " + fields + "(options: " + options + ") on " + dbCollection.getName() + " in " + this.database.getName()));
    }

    @Override
    public void insertEntity(MongoIdentifiableEntity entity, MongoStoreInvocationContext context) {
        Class<?> clazz = entity.getClass();
        EntityInfo entityInfo = this.getEntityInfo(clazz);
        BasicDBObject dbObject = this.mapperRegistry.convertApplicationObjectToDBObject(entity, BasicDBObject.class);
        DBCollection dbCollection = this.database.getCollection(entityInfo.getDbCollectionName());
        String currentId = entity.getId();
        if (currentId == null) {
            currentId = KeycloakModelUtils.generateId();
            entity.setId(currentId);
        }
        dbObject.put("_id", (Object)currentId);
        try {
            dbCollection.insert(new DBObject[]{dbObject});
        }
        catch (MongoException e) {
            throw MongoStoreImpl.convertException(e);
        }
        context.addCreatedEntity(entity);
    }

    public static ModelException convertException(MongoException e) {
        if (e instanceof MongoException.DuplicateKey) {
            return new ModelDuplicateException((Throwable)e);
        }
        return new ModelException((Throwable)e);
    }

    @Override
    public void updateEntity(final MongoIdentifiableEntity entity, MongoStoreInvocationContext context) {
        MongoTask fullUpdateTask = new MongoTask(){

            @Override
            public void execute() {
                Class<?> clazz = entity.getClass();
                EntityInfo entityInfo = MongoStoreImpl.this.getEntityInfo(clazz);
                BasicDBObject dbObject = MongoStoreImpl.this.mapperRegistry.convertApplicationObjectToDBObject(entity, BasicDBObject.class);
                DBCollection dbCollection = MongoStoreImpl.this.database.getCollection(entityInfo.getDbCollectionName());
                String currentId = entity.getId();
                if (currentId == null) {
                    throw new IllegalStateException("Can't update entity without id: " + entity);
                }
                BasicDBObject query = new BasicDBObject("_id", (Object)currentId);
                dbCollection.update((DBObject)query, (DBObject)dbObject);
            }

            @Override
            public boolean isFullUpdate() {
                return true;
            }
        };
        context.addUpdateTask(entity, fullUpdateTask);
    }

    @Override
    public <T extends MongoIdentifiableEntity> T loadEntity(Class<T> type, String id, MongoStoreInvocationContext context) {
        BasicDBObject idQuery;
        T cached = context.getLoadedEntity(type, id);
        if (cached != null && type.isAssignableFrom(cached.getClass())) {
            return cached;
        }
        DBCollection dbCollection = this.getDBCollectionForType(type);
        DBObject dbObject = dbCollection.findOne((DBObject)(idQuery = new BasicDBObject("_id", (Object)id)));
        if (dbObject == null) {
            return null;
        }
        MapperContext<DBObject, T> mapperContext = new MapperContext<DBObject, T>(dbObject, type, null);
        MongoIdentifiableEntity converted = (MongoIdentifiableEntity)this.mapperRegistry.convertDBObjectToApplicationObject(mapperContext);
        context.addLoadedEntity(converted);
        return (T)converted;
    }

    @Override
    public <T extends MongoIdentifiableEntity> T loadSingleEntity(Class<T> type, DBObject query, MongoStoreInvocationContext context) {
        context.beforeDBSearch(type);
        DBCollection dbCollection = this.getDBCollectionForType(type);
        DBObject dbObject = dbCollection.findOne(query);
        if (dbObject == null) {
            return null;
        }
        return this.convertDBObjectToEntity(type, dbObject, context);
    }

    @Override
    public <T extends MongoIdentifiableEntity> List<T> loadEntities(Class<T> type, DBObject query, MongoStoreInvocationContext context) {
        context.beforeDBSearch(type);
        DBCollection dbCollection = this.getDBCollectionForType(type);
        DBCursor cursor = dbCollection.find(query);
        return this.convertCursor(type, cursor, context);
    }

    @Override
    public boolean removeEntity(MongoIdentifiableEntity entity, MongoStoreInvocationContext context) {
        return this.removeEntity(entity.getClass(), entity.getId(), context);
    }

    @Override
    public boolean removeEntity(Class<? extends MongoIdentifiableEntity> type, String id, MongoStoreInvocationContext context) {
        MongoIdentifiableEntity found = this.loadEntity(type, id, context);
        if (found == null) {
            return false;
        }
        DBCollection dbCollection = this.getDBCollectionForType(type);
        BasicDBObject dbQuery = new BasicDBObject("_id", (Object)id);
        dbCollection.remove((DBObject)dbQuery);
        logger.info((Object)("Entity of type: " + type + ", id: " + id + " removed from MongoDB."));
        context.addRemovedEntity(found);
        return true;
    }

    @Override
    public boolean removeEntities(Class<? extends MongoIdentifiableEntity> type, DBObject query, MongoStoreInvocationContext context) {
        List<? extends MongoIdentifiableEntity> foundObjects = this.loadEntities(type, query, context);
        if (foundObjects.size() == 0) {
            return false;
        }
        DBCollection dbCollection = this.getDBCollectionForType(type);
        dbCollection.remove(query);
        logger.info((Object)("Removed " + foundObjects.size() + " entities of type: " + type + ", query: " + query));
        for (MongoIdentifiableEntity mongoIdentifiableEntity : foundObjects) {
            context.addRemovedEntity(mongoIdentifiableEntity);
        }
        return true;
    }

    @Override
    public <S> boolean pushItemToList(final MongoIdentifiableEntity entity, final String listPropertyName, S itemToPush, boolean skipIfAlreadyPresent, MongoStoreInvocationContext context) {
        final Class<?> type = entity.getClass();
        EntityInfo entityInfo = this.getEntityInfo(type);
        Property<Object> listProperty = entityInfo.getPropertyByName(listPropertyName);
        if (listProperty == null) {
            throw new IllegalArgumentException("Property " + listPropertyName + " doesn't exist on object " + entity);
        }
        ArrayList<S> list = (ArrayList<S>)listProperty.getValue((Object)entity);
        if (list == null) {
            list = new ArrayList<S>();
            listProperty.setValue((Object)entity, list);
        }
        if (skipIfAlreadyPresent && list.contains(itemToPush)) {
            return false;
        }
        list.add(itemToPush);
        final ArrayList<S> listt = list;
        context.addUpdateTask(entity, new MongoTask(){

            @Override
            public void execute() {
                BasicDBList dbList = MongoStoreImpl.this.mapperRegistry.convertApplicationObjectToDBObject(listt, BasicDBList.class);
                BasicDBObject query = new BasicDBObject("_id", (Object)entity.getId());
                BasicDBObject listObject = new BasicDBObject(listPropertyName, (Object)dbList);
                BasicDBObject setCommand = new BasicDBObject("$set", (Object)listObject);
                MongoStoreImpl.this.getDBCollectionForType(type).update((DBObject)query, (DBObject)setCommand);
            }

            @Override
            public boolean isFullUpdate() {
                return false;
            }
        });
        return true;
    }

    @Override
    public <S> boolean pullItemFromList(final MongoIdentifiableEntity entity, final String listPropertyName, final S itemToPull, MongoStoreInvocationContext context) {
        final Class<?> type = entity.getClass();
        EntityInfo entityInfo = this.getEntityInfo(type);
        Property<Object> listProperty = entityInfo.getPropertyByName(listPropertyName);
        if (listProperty == null) {
            throw new IllegalArgumentException("Property " + listPropertyName + " doesn't exist on object " + entity);
        }
        List list = (List)listProperty.getValue((Object)entity);
        if (list == null || !list.contains(itemToPull)) {
            return false;
        }
        list.remove(itemToPull);
        context.addUpdateTask(entity, new MongoTask(){

            @Override
            public void execute() {
                Object dbItemToPull = MongoStoreImpl.this.mapperRegistry.convertApplicationObjectToDBObject(itemToPull, Object.class);
                BasicDBObject query = new BasicDBObject("_id", (Object)entity.getId());
                BasicDBObject pullObject = new BasicDBObject(listPropertyName, dbItemToPull);
                BasicDBObject pullCommand = new BasicDBObject("$pull", (Object)pullObject);
                MongoStoreImpl.this.getDBCollectionForType(type).update((DBObject)query, (DBObject)pullCommand);
            }

            @Override
            public boolean isFullUpdate() {
                return false;
            }
        });
        return true;
    }

    @Override
    public void removeAllEntities() {
        Set managedTypes = this.entityInfoCache.keySet();
        Class[] arrayTemplate = new Class[]{};
        this.clearManagedCollections(managedTypes.toArray(arrayTemplate));
    }

    public void addAppObjectConverter(Mapper<?, ?> mapper) {
        this.mapperRegistry.addAppObjectMapper(mapper);
    }

    public void addDBObjectConverter(Mapper<?, ?> mapper) {
        this.mapperRegistry.addDBObjectMapper(mapper);
    }

    public EntityInfo getEntityInfo(Class<?> entityClass) {
        EntityInfo entityInfo = (EntityInfo)this.entityInfoCache.get(entityClass);
        if (entityInfo == null) {
            Map properties = PropertyQueries.createQuery(entityClass).getWritableResultList();
            MongoCollection classAnnotation = entityClass.getAnnotation(MongoCollection.class);
            String dbCollectionName = classAnnotation == null ? null : classAnnotation.collectionName();
            entityInfo = new EntityInfo(entityClass, dbCollectionName, properties);
            EntityInfo existing = this.entityInfoCache.putIfAbsent(entityClass, entityInfo);
            if (existing != null) {
                entityInfo = existing;
            }
        }
        return entityInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends MongoIdentifiableEntity> List<T> convertCursor(Class<T> type, DBCursor cursor, MongoStoreInvocationContext context) {
        ArrayList<T> result = new ArrayList<T>();
        try {
            for (DBObject dbObject : cursor) {
                T entity = this.convertDBObjectToEntity(type, dbObject, context);
                result.add(entity);
            }
        }
        finally {
            cursor.close();
        }
        return result;
    }

    protected <T extends MongoIdentifiableEntity> T convertDBObjectToEntity(Class<T> type, DBObject dbObject, MongoStoreInvocationContext context) {
        String id = dbObject.get("_id").toString();
        Object object = context.getLoadedEntity(type, id);
        if (object == null) {
            MapperContext<DBObject, T> mapperContext = new MapperContext<DBObject, T>(dbObject, type, null);
            object = (MongoIdentifiableEntity)this.mapperRegistry.convertDBObjectToApplicationObject(mapperContext);
            context.addLoadedEntity((MongoIdentifiableEntity)object);
        }
        return object;
    }

    protected DBCollection getDBCollectionForType(Class<?> type) {
        EntityInfo entityInfo = this.getEntityInfo(type);
        String dbCollectionName = entityInfo.getDbCollectionName();
        return dbCollectionName == null ? null : this.database.getCollection(dbCollectionName);
    }
}

