/*
 * Decompiled with CFR 0.152.
 */
package de.idyl.winzipaes.impl;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class AESUtilsJCA {
    public static final int ITERATION_COUNT = 1000;
    public static final int BLOCK_SIZE = 16;
    private final Cipher cipher;
    private final Mac mac;
    private final byte[] passwordVerifier;
    private final byte[] iv = new byte[16];
    private final byte[] keystream = new byte[16];
    private int next = 16;

    public AESUtilsJCA(String password, int keySize, byte[] salt) {
        if (keySize != 128 && keySize != 192 && keySize != 256) {
            throw new IllegalArgumentException("Illegal keysize: " + keySize);
        }
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            char[] passwordChars = password.toCharArray();
            PBEKeySpec keySpec = new PBEKeySpec(passwordChars, salt, 1000, keySize * 2 + 16);
            SecretKey sk = skf.generateSecret(keySpec);
            byte[] keyBytes = sk.getEncoded();
            this.cipher = Cipher.getInstance("AES");
            SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, 0, keySize / 8, "AES");
            this.cipher.init(1, secretKeySpec);
            this.mac = Mac.getInstance("HmacSHA1");
            this.mac.init(new SecretKeySpec(keyBytes, keySize / 8, keySize / 8, "HmacSHA1"));
            this.passwordVerifier = new byte[2];
            System.arraycopy(keyBytes, 2 * (keySize / 8), this.passwordVerifier, 0, 2);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            throw new Error();
        }
        catch (InvalidKeySpecException e) {
            throw new Error();
        }
        catch (NoSuchPaddingException e) {
            throw new Error();
        }
    }

    public void cryptUpdate(byte[] in, int length) {
        try {
            int i = 0;
            while (i < length) {
                if (this.next == 16) {
                    int j = 0;
                    while (j < 16) {
                        int n = j++;
                        this.iv[n] = (byte)(this.iv[n] + 1);
                        if (this.iv[n] != 0) break;
                    }
                    this.cipher.update(this.iv, 0, 16, this.keystream);
                    this.next = 0;
                }
                int n = i++;
                in[n] = (byte)(in[n] ^ this.keystream[this.next++]);
            }
        }
        catch (ShortBufferException e) {
            throw new Error();
        }
    }

    public void authUpdate(byte[] in, int length) {
        this.mac.update(in, 0, length);
    }

    public byte[] getFinalAuthentifier() {
        byte[] auth = new byte[10];
        System.arraycopy(this.mac.doFinal(), 0, auth, 0, 10);
        return auth;
    }

    public byte[] getPasswordVerifier() {
        return this.passwordVerifier;
    }
}

