/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.freemarker;

import java.util.concurrent.ConcurrentHashMap;
import org.keycloak.Config;
import org.keycloak.freemarker.ExtendingThemeManager;
import org.keycloak.freemarker.Theme;
import org.keycloak.freemarker.ThemeProvider;
import org.keycloak.freemarker.ThemeProviderFactory;
import org.keycloak.models.KeycloakSession;

public class ExtendingThemeManagerFactory
implements ThemeProviderFactory {
    private ConcurrentHashMap<ThemeKey, Theme> themeCache = new ConcurrentHashMap();
    private ExtendingThemeManager themeManager;

    public ThemeProvider create(KeycloakSession session) {
        return new ExtendingThemeManager(session, this.themeCache);
    }

    public void init(Config.Scope config) {
        if (Config.scope((String[])new String[]{"theme"}).getBoolean("cacheThemes", Boolean.valueOf(true)).booleanValue()) {
            this.themeCache = new ConcurrentHashMap();
        }
    }

    public void close() {
    }

    public String getId() {
        return "extending";
    }

    public static class ThemeKey {
        private String name;
        private Theme.Type type;

        public static ThemeKey get(String name, Theme.Type type) {
            return new ThemeKey(name, type);
        }

        private ThemeKey(String name, Theme.Type type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Theme.Type getType() {
            return this.type;
        }

        public void setType(Theme.Type type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ThemeKey themeKey = (ThemeKey)o;
            if (this.name != null ? !this.name.equals(themeKey.name) : themeKey.name != null) {
                return false;
            }
            return this.type == themeKey.type;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }
    }
}

