/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.keycloak.models.jpa.entities.UserEntity;

@NamedQueries(value={@NamedQuery(name="findSocialLinkByUser", query="select link from SocialLinkEntity link where link.user = :user"), @NamedQuery(name="findSocialLinkByUserAndProvider", query="select link from SocialLinkEntity link where link.user = :user and link.socialProvider = :socialProvider"), @NamedQuery(name="findUserByLinkAndRealm", query="select link.user from SocialLinkEntity link where link.realmId = :realmId and link.socialProvider = :socialProvider and link.socialUserId = :socialUserId"), @NamedQuery(name="deleteSocialLinkByRealm", query="delete from SocialLinkEntity social where social.user IN (select u from UserEntity u where realmId=:realmId)"), @NamedQuery(name="deleteSocialLinkByRealmAndLink", query="delete from SocialLinkEntity social where social.user IN (select u from UserEntity u where realmId=:realmId and u.federationLink=:link)"), @NamedQuery(name="deleteSocialLinkByUser", query="delete from SocialLinkEntity social where social.user = :user")})
@Table(name="USER_SOCIAL_LINK")
@Entity
@IdClass(value=Key.class)
public class SocialLinkEntity {
    @Id
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="USER_ID")
    private UserEntity user;
    @Column(name="REALM_ID")
    protected String realmId;
    @Id
    @Column(name="SOCIAL_PROVIDER")
    protected String socialProvider;
    @Column(name="SOCIAL_USER_ID")
    protected String socialUserId;
    @Column(name="SOCIAL_USERNAME")
    protected String socialUsername;

    public UserEntity getUser() {
        return this.user;
    }

    public void setUser(UserEntity user) {
        this.user = user;
    }

    public String getSocialProvider() {
        return this.socialProvider;
    }

    public void setSocialProvider(String socialProvider) {
        this.socialProvider = socialProvider;
    }

    public String getSocialUserId() {
        return this.socialUserId;
    }

    public void setSocialUserId(String socialUserId) {
        this.socialUserId = socialUserId;
    }

    public String getSocialUsername() {
        return this.socialUsername;
    }

    public void setSocialUsername(String socialUsername) {
        this.socialUsername = socialUsername;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    public static class Key
    implements Serializable {
        protected UserEntity user;
        protected String socialProvider;

        public Key() {
        }

        public Key(UserEntity user, String socialProvider) {
            this.user = user;
            this.socialProvider = socialProvider;
        }

        public UserEntity getUser() {
            return this.user;
        }

        public String getSocialProvider() {
            return this.socialProvider;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.socialProvider != null ? !this.socialProvider.equals(key.socialProvider) : key.socialProvider != null) {
                return false;
            }
            return !(this.user != null ? !this.user.getId().equals(key.user != null ? key.user.getId() : null) : key.user != null);
        }

        public int hashCode() {
            int result = this.user != null ? this.user.getId().hashCode() : 0;
            result = 31 * result + (this.socialProvider != null ? this.socialProvider.hashCode() : 0);
            return result;
        }
    }
}

