/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.audit;

import java.util.HashMap;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.audit.AuditListener;
import org.keycloak.audit.Event;
import org.keycloak.audit.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;

public class Audit {
    private static final Logger log = Logger.getLogger(Audit.class);
    private List<AuditListener> listeners;
    private Event event;

    public Audit(List<AuditListener> listeners, RealmModel realm, String ipAddress) {
        this.listeners = listeners;
        this.event = new Event();
        this.realm(realm);
        this.ipAddress(ipAddress);
    }

    Audit() {
    }

    public Audit realm(RealmModel realm) {
        this.event.setRealmId(realm.getId());
        return this;
    }

    public Audit realm(String realmId) {
        this.event.setRealmId(realmId);
        return this;
    }

    public Audit client(ClientModel client) {
        this.event.setClientId(client.getClientId());
        return this;
    }

    public Audit client(String clientId) {
        this.event.setClientId(clientId);
        return this;
    }

    public Audit user(UserModel user) {
        this.event.setUserId(user.getId());
        return this;
    }

    public Audit user(String userId) {
        this.event.setUserId(userId);
        return this;
    }

    public Audit session(UserSessionModel session) {
        this.event.setSessionId(session.getId());
        return this;
    }

    public Audit session(String sessionId) {
        this.event.setSessionId(sessionId);
        return this;
    }

    public Audit ipAddress(String ipAddress) {
        this.event.setIpAddress(ipAddress);
        return this;
    }

    public Audit event(EventType e) {
        this.event.setEvent(e);
        return this;
    }

    public Audit detail(String key, String value) {
        if (value == null || value.equals("")) {
            return this;
        }
        if (this.event.getDetails() == null) {
            this.event.setDetails(new HashMap<String, String>());
        }
        this.event.getDetails().put(key, value);
        return this;
    }

    public Audit removeDetail(String key) {
        if (this.event.getDetails() != null) {
            this.event.getDetails().remove(key);
        }
        return this;
    }

    public Event getEvent() {
        return this.event;
    }

    public void success() {
        this.send();
    }

    public void error(String error) {
        this.event.setEvent(EventType.valueOf(this.event.getEvent().name() + "_ERROR"));
        this.event.setError(error);
        this.send();
    }

    public Audit clone() {
        Audit clone = new Audit();
        clone.listeners = this.listeners;
        clone.event = this.event.clone();
        return clone;
    }

    public Audit reset() {
        Event old = this.event;
        this.event = new Event();
        this.event.setRealmId(old.getRealmId());
        this.event.setIpAddress(old.getIpAddress());
        this.event.setClientId(old.getClientId());
        this.event.setUserId(old.getUserId());
        return this;
    }

    private void send() {
        this.event.setTime(System.currentTimeMillis());
        if (this.listeners != null) {
            for (AuditListener l : this.listeners) {
                try {
                    l.onEvent(this.event);
                }
                catch (Throwable t) {
                    log.error((Object)("Failed to send event to " + l), t);
                }
            }
        }
    }
}

