/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.mongo;

import java.util.LinkedList;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.mongo.AbstractMongoAdapter;
import org.keycloak.models.sessions.mongo.ClientSessionAdapter;
import org.keycloak.models.sessions.mongo.MongoUserSessionProvider;
import org.keycloak.models.sessions.mongo.entities.MongoClientSessionEntity;
import org.keycloak.models.sessions.mongo.entities.MongoUserSessionEntity;

public class UserSessionAdapter
extends AbstractMongoAdapter<MongoUserSessionEntity>
implements UserSessionModel {
    private static final Logger logger = Logger.getLogger(UserSessionAdapter.class);
    private final MongoUserSessionProvider provider;
    private MongoUserSessionEntity entity;
    private RealmModel realm;
    private KeycloakSession keycloakSession;
    private final MongoStoreInvocationContext invContext;

    public UserSessionAdapter(KeycloakSession keycloakSession, MongoUserSessionProvider provider, MongoUserSessionEntity entity, RealmModel realm, MongoStoreInvocationContext invContext) {
        super(invContext);
        this.provider = provider;
        this.entity = entity;
        this.realm = realm;
        this.keycloakSession = keycloakSession;
        this.invContext = invContext;
    }

    @Override
    protected MongoUserSessionEntity getMongoEntity() {
        return this.entity;
    }

    public String getId() {
        return this.entity.getId();
    }

    public void setId(String id) {
        this.entity.setId(id);
        this.updateMongoEntity();
    }

    public UserModel getUser() {
        return this.keycloakSession.users().getUserById(this.entity.getUser(), this.realm);
    }

    public void setUser(UserModel user) {
        this.entity.setUser(user.getId());
        this.updateMongoEntity();
    }

    public String getLoginUsername() {
        return this.entity.getLoginUsername();
    }

    public void setLoginUsername(String loginUsername) {
        this.entity.setLoginUsername(loginUsername);
        this.updateMongoEntity();
    }

    public String getIpAddress() {
        return this.entity.getIpAddress();
    }

    public void setIpAddress(String ipAddress) {
        this.entity.setIpAddress(ipAddress);
        this.updateMongoEntity();
    }

    public String getAuthMethod() {
        return this.entity.getAuthMethod();
    }

    public void setAuthMethod(String authMethod) {
        this.entity.setAuthMethod(authMethod);
        this.updateMongoEntity();
    }

    public boolean isRememberMe() {
        return this.entity.isRememberMe();
    }

    public void setRememberMe(boolean rememberMe) {
        this.entity.setRememberMe(rememberMe);
        this.updateMongoEntity();
    }

    public int getStarted() {
        return this.entity.getStarted();
    }

    public void setStarted(int started) {
        this.entity.setStarted(started);
        this.updateMongoEntity();
    }

    public int getLastSessionRefresh() {
        return this.entity.getLastSessionRefresh();
    }

    public void setLastSessionRefresh(int seconds) {
        this.entity.setLastSessionRefresh(seconds);
        this.updateMongoEntity();
    }

    public List<ClientSessionModel> getClientSessions() {
        LinkedList<ClientSessionModel> sessions = new LinkedList<ClientSessionModel>();
        for (MongoClientSessionEntity e : this.entity.getClientSessions()) {
            sessions.add(new ClientSessionAdapter(this.keycloakSession, this.provider, this.realm, e, this.entity, this.invocationContext));
        }
        return sessions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserSessionModel)) {
            return false;
        }
        UserSessionModel that = (UserSessionModel)o;
        return that.getId().equals(this.getId());
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode();
    }
}

