/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.client.HttpClient;
import org.jboss.logging.Logger;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.keycloak.TokenIdGenerator;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.adapters.action.LogoutAction;
import org.keycloak.representations.adapters.action.PushNotBeforeAction;
import org.keycloak.representations.adapters.action.SessionStats;
import org.keycloak.representations.adapters.action.SessionStatsAction;
import org.keycloak.representations.adapters.action.UserStats;
import org.keycloak.representations.adapters.action.UserStatsAction;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.util.HttpClientBuilder;
import org.keycloak.services.util.ResolveRelative;
import org.keycloak.util.Time;

public class ResourceAdminManager {
    protected static Logger logger = Logger.getLogger(ResourceAdminManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionStats getSessionStats(URI requestUri, KeycloakSession session, RealmModel realm, ApplicationModel application, boolean users) {
        ApacheHttpClient4Executor executor = ResourceAdminManager.createExecutor();
        try {
            SessionStats sessionStats = this.getSessionStats(requestUri, session, realm, application, users, executor);
            return sessionStats;
        }
        finally {
            executor.getHttpClient().getConnectionManager().shutdown();
        }
    }

    public static ApacheHttpClient4Executor createExecutor() {
        HttpClient client = new HttpClientBuilder().disableTrustManager().build();
        return new ApacheHttpClient4Executor(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionStats getSessionStats(URI requestUri, KeycloakSession session, RealmModel realm, ApplicationModel application, boolean users, ApacheHttpClient4Executor client) {
        String managementUrl = this.getManagementUrl(requestUri, application);
        if (managementUrl != null) {
            SessionStatsAction adminAction = new SessionStatsAction(TokenIdGenerator.generateId(), Time.currentTime() + 30, application.getName());
            adminAction.setListUsers(users);
            String token = new TokenManager().encodeToken(realm, adminAction);
            logger.debugv("session stats for application: {0} url: {1}", (Object)application.getName(), (Object)managementUrl);
            ClientRequest request = client.createRequest(UriBuilder.fromUri((String)managementUrl).path("k_get_session_stats").build(new Object[0]).toString());
            ClientResponse response = null;
            try {
                response = request.body(MediaType.TEXT_PLAIN_TYPE, (Object)token).post(SessionStats.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                if (response.getStatus() != 200) {
                    logger.warn((Object)("Failed to get stats: " + response.getStatus()));
                    SessionStats e = null;
                    return e;
                }
                SessionStats stats = (SessionStats)response.getEntity();
                if (users && stats.getUsers() != null) {
                    HashMap newUsers = new HashMap();
                    for (Map.Entry entry : stats.getUsers().entrySet()) {
                        UserModel user = session.users().getUserById((String)entry.getKey(), realm);
                        if (user == null) continue;
                        newUsers.put(user.getUsername(), entry.getValue());
                    }
                    stats.setUsers(newUsers);
                }
                SessionStats sessionStats = stats;
                return sessionStats;
            }
            finally {
                response.releaseConnection();
            }
        }
        logger.debug((Object)"no management url.");
        return null;
    }

    protected String getManagementUrl(URI requestUri, ApplicationModel application) {
        String mgmtUrl = application.getManagementUrl();
        return ResolveRelative.resolveRelativeUri(requestUri, mgmtUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserStats getUserStats(URI requestUri, RealmModel realm, ApplicationModel application, UserModel user) {
        ApacheHttpClient4Executor executor = ResourceAdminManager.createExecutor();
        try {
            UserStats userStats = this.getUserStats(requestUri, realm, application, user, executor);
            return userStats;
        }
        finally {
            executor.getHttpClient().getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserStats getUserStats(URI requestUri, RealmModel realm, ApplicationModel application, UserModel user, ApacheHttpClient4Executor client) {
        String managementUrl = this.getManagementUrl(requestUri, application);
        if (managementUrl != null) {
            UserStatsAction adminAction = new UserStatsAction(TokenIdGenerator.generateId(), Time.currentTime() + 30, application.getName(), user.getId());
            String token = new TokenManager().encodeToken(realm, adminAction);
            logger.debugv("session stats for application: {0} url: {1}", (Object)application.getName(), (Object)managementUrl);
            ClientRequest request = client.createRequest(UriBuilder.fromUri((String)managementUrl).path("k_get_user_stats").build(new Object[0]).toString());
            ClientResponse response = null;
            try {
                response = request.body(MediaType.TEXT_PLAIN_TYPE, (Object)token).post(UserStats.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                UserStats stats;
                if (response.getStatus() != 200) {
                    logger.warn((Object)("Failed to get stats: " + response.getStatus()));
                    UserStats e = null;
                    return e;
                }
                UserStats userStats = stats = (UserStats)response.getEntity();
                return userStats;
            }
            finally {
                response.releaseConnection();
            }
        }
        logger.debug((Object)"no management url.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logoutUser(URI requestUri, RealmModel realm, String user, String session) {
        ApacheHttpClient4Executor executor = ResourceAdminManager.createExecutor();
        try {
            List resources = realm.getApplications();
            logger.debugv("logging out {0} resources ", (Object)resources.size());
            for (ApplicationModel resource : resources) {
                this.logoutApplication(requestUri, realm, resource, user, session, executor, 0);
            }
        }
        finally {
            executor.getHttpClient().getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logoutSession(URI requestUri, RealmModel realm, String session) {
        ApacheHttpClient4Executor executor = ResourceAdminManager.createExecutor();
        try {
            List resources = realm.getApplications();
            logger.debugv("logging out {0} resources ", (Object)resources.size());
            for (ApplicationModel resource : resources) {
                this.logoutApplication(requestUri, realm, resource, null, session, executor, 0);
            }
        }
        finally {
            executor.getHttpClient().getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logoutAll(URI requestUri, RealmModel realm) {
        ApacheHttpClient4Executor executor = ResourceAdminManager.createExecutor();
        try {
            realm.setNotBefore(Time.currentTime());
            List resources = realm.getApplications();
            logger.debugv("logging out {0} resources ", (Object)resources.size());
            for (ApplicationModel resource : resources) {
                this.logoutApplication(requestUri, realm, resource, null, null, executor, realm.getNotBefore());
            }
        }
        finally {
            executor.getHttpClient().getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logoutApplication(URI requestUri, RealmModel realm, ApplicationModel resource, String user, String session) {
        ApacheHttpClient4Executor executor = ResourceAdminManager.createExecutor();
        try {
            resource.setNotBefore(Time.currentTime());
            this.logoutApplication(requestUri, realm, resource, user, session, executor, resource.getNotBefore());
        }
        finally {
            executor.getHttpClient().getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean logoutApplication(URI requestUri, RealmModel realm, ApplicationModel resource, String user, String session, ApacheHttpClient4Executor client, int notBefore) {
        String managementUrl = this.getManagementUrl(requestUri, resource);
        if (managementUrl != null) {
            ClientResponse response;
            LogoutAction adminAction = new LogoutAction(TokenIdGenerator.generateId(), Time.currentTime() + 30, resource.getName(), user, session, notBefore);
            String token = new TokenManager().encodeToken(realm, adminAction);
            logger.debugv("logout user: {0} resource: {1} url: {2}", (Object)user, (Object)resource.getName(), (Object)managementUrl);
            ClientRequest request = client.createRequest(UriBuilder.fromUri((String)managementUrl).path("k_logout").build(new Object[0]).toString());
            try {
                response = request.body(MediaType.TEXT_PLAIN_TYPE, (Object)token).post(UserStats.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                boolean success = response.getStatus() == 204;
                logger.debug((Object)"logout success.");
                boolean bl = success;
                return bl;
            }
            finally {
                response.releaseConnection();
            }
        }
        logger.debugv("Can't logout {0}: no management url", (Object)resource.getName());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushRealmRevocationPolicy(URI requestUri, RealmModel realm) {
        ApacheHttpClient4Executor executor = ResourceAdminManager.createExecutor();
        try {
            for (ApplicationModel application : realm.getApplications()) {
                this.pushRevocationPolicy(requestUri, realm, application, realm.getNotBefore(), executor);
            }
        }
        finally {
            executor.getHttpClient().getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushApplicationRevocationPolicy(URI requestUri, RealmModel realm, ApplicationModel application) {
        ApacheHttpClient4Executor executor = ResourceAdminManager.createExecutor();
        try {
            this.pushRevocationPolicy(requestUri, realm, application, application.getNotBefore(), executor);
        }
        finally {
            executor.getHttpClient().getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean pushRevocationPolicy(URI requestUri, RealmModel realm, ApplicationModel resource, int notBefore, ApacheHttpClient4Executor client) {
        if (notBefore <= 0) {
            return false;
        }
        String managementUrl = this.getManagementUrl(requestUri, resource);
        if (managementUrl != null) {
            PushNotBeforeAction adminAction = new PushNotBeforeAction(TokenIdGenerator.generateId(), Time.currentTime() + 30, resource.getName(), notBefore);
            String token = new TokenManager().encodeToken(realm, adminAction);
            logger.debugv("pushRevocation resource: {0} url: {1}", (Object)resource.getName(), (Object)managementUrl);
            ClientRequest request = client.createRequest(UriBuilder.fromUri((String)managementUrl).path("k_push_not_before").build(new Object[0]).toString());
            ClientResponse response = null;
            try {
                response = request.body(MediaType.TEXT_PLAIN_TYPE, (Object)token).post();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                boolean success = response.getStatus() == 204;
                logger.debug((Object)"pushRevocation success.");
                boolean bl = success;
                return bl;
            }
            finally {
                response.releaseConnection();
            }
        }
        logger.debug((Object)("no management URL for application: " + resource.getName()));
        return false;
    }
}

