/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.Signature;
import java.util.HashSet;
import java.util.Set;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.jose.jws.crypto.RSAProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.util.Base64Url;
import org.keycloak.util.Time;

public class AccessCode {
    private final RealmModel realm;
    private final ClientSessionModel clientSession;

    public AccessCode(RealmModel realm, ClientSessionModel clientSession) {
        this.realm = realm;
        this.clientSession = clientSession;
    }

    public static AccessCode parse(String code, KeycloakSession session, RealmModel realm) {
        try {
            String[] parts = code.split("\\.");
            String id = new String(Base64Url.decode((String)parts[1]));
            ClientSessionModel clientSession = session.sessions().getClientSession(realm, id);
            if (clientSession == null) {
                return null;
            }
            String hash = AccessCode.createSignatureHash(realm, clientSession);
            if (!hash.equals(parts[0])) {
                return null;
            }
            return new AccessCode(realm, clientSession);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public String getCodeId() {
        return this.clientSession.getId();
    }

    public UserModel getUser() {
        return this.clientSession.getUserSession().getUser();
    }

    public String getSessionState() {
        return this.clientSession.getUserSession().getId();
    }

    public boolean isValid(UserModel.RequiredAction requiredAction) {
        return this.isValid(this.convertToAction(requiredAction));
    }

    public boolean isValid(ClientSessionModel.Action requestedAction) {
        ClientSessionModel.Action action = this.clientSession.getAction();
        if (action == null) {
            return false;
        }
        int timestamp = this.clientSession.getTimestamp();
        if (!action.equals((Object)requestedAction)) {
            return false;
        }
        int lifespan = action.equals((Object)ClientSessionModel.Action.CODE_TO_TOKEN) ? this.realm.getAccessCodeLifespan() : this.realm.getAccessCodeLifespanUserAction();
        return timestamp + lifespan > Time.currentTime();
    }

    public Set<RoleModel> getRequestedRoles() {
        HashSet<RoleModel> requestedRoles = new HashSet<RoleModel>();
        for (String roleId : this.clientSession.getRoles()) {
            RoleModel role = this.realm.getRoleById(roleId);
            if (role == null) continue;
            requestedRoles.add(this.realm.getRoleById(roleId));
        }
        return requestedRoles;
    }

    public ClientModel getClient() {
        return this.clientSession.getClient();
    }

    public String getState() {
        return this.clientSession.getState();
    }

    public String getRedirectUri() {
        return this.clientSession.getRedirectUri();
    }

    public ClientSessionModel.Action getAction() {
        return this.clientSession.getAction();
    }

    public void setAction(ClientSessionModel.Action action) {
        this.clientSession.setAction(action);
        this.clientSession.setTimestamp(Time.currentTime());
    }

    public void setRequiredAction(UserModel.RequiredAction requiredAction) {
        this.setAction(this.convertToAction(requiredAction));
    }

    private ClientSessionModel.Action convertToAction(UserModel.RequiredAction requiredAction) {
        switch (requiredAction) {
            case CONFIGURE_TOTP: {
                return ClientSessionModel.Action.CONFIGURE_TOTP;
            }
            case UPDATE_PASSWORD: {
                return ClientSessionModel.Action.UPDATE_PASSWORD;
            }
            case UPDATE_PROFILE: {
                return ClientSessionModel.Action.UPDATE_PROFILE;
            }
            case VERIFY_EMAIL: {
                return ClientSessionModel.Action.VERIFY_EMAIL;
            }
        }
        throw new IllegalArgumentException("Unknown required action " + requiredAction);
    }

    public String getCode() {
        String hash = AccessCode.createSignatureHash(this.realm, this.clientSession);
        StringBuilder sb = new StringBuilder();
        sb.append(hash);
        sb.append(".");
        sb.append(Base64Url.encode((byte[])this.clientSession.getId().getBytes()));
        return sb.toString();
    }

    private static String createSignatureHash(RealmModel realm, ClientSessionModel clientSession) {
        try {
            Signature signature = Signature.getInstance(RSAProvider.getJavaAlgorithm((Algorithm)Algorithm.RS256));
            signature.initSign(realm.getPrivateKey());
            signature.update(clientSession.getId().getBytes());
            signature.update(ByteBuffer.allocate(4).putInt(clientSession.getTimestamp()));
            if (clientSession.getAction() != null) {
                signature.update(clientSession.getAction().toString().getBytes());
            }
            byte[] sign = signature.sign();
            MessageDigest digest = MessageDigest.getInstance("sha-1");
            digest.update(sign);
            return Base64Url.encode((byte[])digest.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

