/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.flows;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.keycloak.ClientConnection;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.resources.SocialResource;
import org.keycloak.services.resources.flows.Urls;
import org.keycloak.services.util.CookieHelper;
import org.keycloak.social.AuthRequest;
import org.keycloak.social.SocialProvider;
import org.keycloak.social.SocialProviderConfig;
import org.keycloak.social.SocialProviderException;

public class SocialRedirectFlows {
    private final RealmModel realm;
    private final UriInfo uriInfo;
    private ClientConnection clientConnection;
    private final SocialProvider socialProvider;
    private final SocialResource.State state;

    SocialRedirectFlows(RealmModel realm, UriInfo uriInfo, ClientConnection clientConnection, SocialProvider provider) {
        this.realm = realm;
        this.uriInfo = uriInfo;
        this.clientConnection = clientConnection;
        this.socialProvider = provider;
        this.state = new SocialResource.State();
        this.state.setRealm(realm.getName());
        this.state.setProvider(provider.getId());
    }

    public SocialRedirectFlows putClientAttribute(String key, String value) {
        this.state.set(key, value);
        return this;
    }

    public SocialRedirectFlows user(UserModel user) {
        this.state.setUser(user.getId());
        return this;
    }

    public Response redirectToSocialProvider() throws SocialProviderException {
        String encodedState;
        String callbackUri;
        String secret;
        String socialProviderId = this.socialProvider.getId();
        String key = (String)this.realm.getSocialConfig().get(socialProviderId + ".key");
        SocialProviderConfig config = new SocialProviderConfig(key, secret = (String)this.realm.getSocialConfig().get(socialProviderId + ".secret"), callbackUri = Urls.socialCallback(this.uriInfo.getBaseUri()).toString());
        AuthRequest authRequest = this.socialProvider.getAuthUrl(config, encodedState = new JWSBuilder().jsonContent((Object)this.state).rsa256(this.realm.getPrivateKey()));
        if (authRequest.getAttributes() != null) {
            String cookiePath = Urls.socialBase(this.uriInfo.getBaseUri()).build(new Object[0]).getRawPath().toString();
            String encoded = new JWSBuilder().jsonContent((Object)authRequest.getAttributes()).rsa256(this.realm.getPrivateKey());
            CookieHelper.addCookie("KEYCLOAK_SOCIAL", encoded, cookiePath, null, null, -1, this.realm.getSslRequired().isRequired(this.clientConnection), true);
        }
        return Response.status((int)302).location(authRequest.getAuthUri()).build();
    }
}

