/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.mem;

import java.util.Set;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.mem.MemUserSessionProvider;
import org.keycloak.models.sessions.mem.UserSessionAdapter;
import org.keycloak.models.sessions.mem.entities.ClientSessionEntity;

public class ClientSessionAdapter
implements ClientSessionModel {
    private KeycloakSession session;
    private MemUserSessionProvider provider;
    private RealmModel realm;
    private ClientSessionEntity entity;

    public ClientSessionAdapter(KeycloakSession session, MemUserSessionProvider provider, RealmModel realm, ClientSessionEntity entity) {
        this.session = session;
        this.provider = provider;
        this.realm = realm;
        this.entity = entity;
    }

    public String getId() {
        return this.entity.getId();
    }

    public ClientModel getClient() {
        return this.realm.findClientById(this.entity.getClientId());
    }

    public String getState() {
        return this.entity.getState();
    }

    public UserSessionModel getUserSession() {
        return new UserSessionAdapter(this.session, this.provider, this.realm, this.entity.getSession());
    }

    public String getRedirectUri() {
        return this.entity.getRedirectUri();
    }

    public int getTimestamp() {
        return this.entity.getTimestamp();
    }

    public void setTimestamp(int timestamp) {
        this.entity.setTimestamp(timestamp);
    }

    public ClientSessionModel.Action getAction() {
        return this.entity.getAction();
    }

    public void setAction(ClientSessionModel.Action action) {
        this.entity.setAction(action);
    }

    public Set<String> getRoles() {
        return this.entity.getRoles();
    }
}

