/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.keycloak.connections.mongo.api.MongoIdentifiableEntity;
import org.keycloak.connections.mongo.api.MongoStore;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.entities.SocialLinkEntity;
import org.keycloak.models.mongo.keycloak.adapters.UserAdapter;
import org.keycloak.models.mongo.keycloak.entities.MongoUserEntity;
import org.keycloak.models.utils.CredentialValidation;

public class MongoUserProvider
implements UserProvider {
    private final MongoStoreInvocationContext invocationContext;
    private final KeycloakSession session;
    private final MongoStore mongoStore;

    public MongoUserProvider(KeycloakSession session, MongoStore mongoStore, MongoStoreInvocationContext invocationContext) {
        this.session = session;
        this.mongoStore = mongoStore;
        this.invocationContext = invocationContext;
    }

    public void close() {
    }

    public UserModel getUserById(String id, RealmModel realm) {
        MongoUserEntity user = (MongoUserEntity)this.getMongoStore().loadEntity(MongoUserEntity.class, id, this.invocationContext);
        if (user == null || !realm.getId().equals(user.getRealmId())) {
            return null;
        }
        return new UserAdapter(this.session, realm, user, this.invocationContext);
    }

    public UserModel getUserByUsername(String username, RealmModel realm) {
        DBObject query = new QueryBuilder().and("username").is((Object)username).and("realmId").is((Object)realm.getId()).get();
        MongoUserEntity user = (MongoUserEntity)this.getMongoStore().loadSingleEntity(MongoUserEntity.class, query, this.invocationContext);
        if (user == null) {
            return null;
        }
        return new UserAdapter(this.session, realm, user, this.invocationContext);
    }

    public UserModel getUserByEmail(String email, RealmModel realm) {
        DBObject query = new QueryBuilder().and("email").is((Object)email).and("realmId").is((Object)realm.getId()).get();
        MongoUserEntity user = (MongoUserEntity)this.getMongoStore().loadSingleEntity(MongoUserEntity.class, query, this.invocationContext);
        if (user == null) {
            return null;
        }
        return new UserAdapter(this.session, realm, user, this.invocationContext);
    }

    protected MongoStore getMongoStore() {
        return this.invocationContext.getMongoStore();
    }

    public UserModel getUserBySocialLink(SocialLinkModel socialLink, RealmModel realm) {
        DBObject query = new QueryBuilder().and("socialLinks.socialProvider").is((Object)socialLink.getSocialProvider()).and("socialLinks.socialUserId").is((Object)socialLink.getSocialUserId()).and("realmId").is((Object)realm.getId()).get();
        MongoUserEntity userEntity = (MongoUserEntity)this.getMongoStore().loadSingleEntity(MongoUserEntity.class, query, this.invocationContext);
        return userEntity == null ? null : new UserAdapter(this.session, realm, userEntity, this.invocationContext);
    }

    protected List<UserModel> convertUserEntities(RealmModel realm, List<MongoUserEntity> userEntities) {
        ArrayList<UserModel> userModels = new ArrayList<UserModel>();
        for (MongoUserEntity user : userEntities) {
            userModels.add(new UserAdapter(this.session, realm, user, this.invocationContext));
        }
        return userModels;
    }

    public List<UserModel> getUsers(RealmModel realm) {
        return this.getUsers(realm, -1, -1);
    }

    public int getUsersCount(RealmModel realm) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)realm.getId()).get();
        return this.getMongoStore().countEntities(MongoUserEntity.class, query, this.invocationContext);
    }

    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)realm.getId()).get();
        BasicDBObject sort = new BasicDBObject("username", (Object)1);
        List users = this.getMongoStore().loadEntities(MongoUserEntity.class, query, (DBObject)sort, firstResult, maxResults, this.invocationContext);
        return this.convertUserEntities(realm, users);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm) {
        return this.searchForUser(search, realm, -1, -1);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm, int firstResult, int maxResults) {
        QueryBuilder nameBuilder;
        search = search.trim();
        Pattern caseInsensitivePattern = Pattern.compile("(?i:" + search + ")");
        int spaceInd = search.lastIndexOf(" ");
        if (spaceInd != -1) {
            String firstName = search.substring(0, spaceInd);
            String lastName = search.substring(spaceInd + 1);
            Pattern firstNamePattern = Pattern.compile("(?i:" + firstName + "$)");
            Pattern lastNamePattern = Pattern.compile("(?i:^" + lastName + ")");
            nameBuilder = new QueryBuilder().and(new DBObject[]{new QueryBuilder().put("firstName").regex(firstNamePattern).get(), new QueryBuilder().put("lastName").regex(lastNamePattern).get()});
        } else {
            nameBuilder = new QueryBuilder().or(new DBObject[]{new QueryBuilder().put("firstName").regex(caseInsensitivePattern).get(), new QueryBuilder().put("lastName").regex(caseInsensitivePattern).get()});
        }
        QueryBuilder builder = new QueryBuilder().and(new DBObject[]{new QueryBuilder().and("realmId").is((Object)realm.getId()).get(), new QueryBuilder().or(new DBObject[]{new QueryBuilder().put("username").regex(caseInsensitivePattern).get(), new QueryBuilder().put("email").regex(caseInsensitivePattern).get(), nameBuilder.get()}).get()});
        BasicDBObject sort = new BasicDBObject("username", (Object)1);
        List users = this.getMongoStore().loadEntities(MongoUserEntity.class, builder.get(), (DBObject)sort, firstResult, maxResults, this.invocationContext);
        return this.convertUserEntities(realm, users);
    }

    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes, RealmModel realm) {
        return this.searchForUserByAttributes(attributes, realm, -1, -1);
    }

    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes, RealmModel realm, int firstResult, int maxResults) {
        QueryBuilder queryBuilder = new QueryBuilder().and("realmId").is((Object)realm.getId());
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (entry.getKey().equalsIgnoreCase("username")) {
                queryBuilder.and("username").regex(Pattern.compile(".*" + entry.getValue() + ".*", 2));
                continue;
            }
            if (entry.getKey().equalsIgnoreCase("firstName")) {
                queryBuilder.and("firstName").regex(Pattern.compile(".*" + entry.getValue() + ".*", 2));
                continue;
            }
            if (entry.getKey().equalsIgnoreCase("lastName")) {
                queryBuilder.and("lastName").regex(Pattern.compile(".*" + entry.getValue() + ".*", 2));
                continue;
            }
            if (!entry.getKey().equalsIgnoreCase("email")) continue;
            queryBuilder.and("email").regex(Pattern.compile(".*" + entry.getValue() + ".*", 2));
        }
        BasicDBObject sort = new BasicDBObject("username", (Object)1);
        List users = this.getMongoStore().loadEntities(MongoUserEntity.class, queryBuilder.get(), (DBObject)sort, firstResult, maxResults, this.invocationContext);
        return this.convertUserEntities(realm, users);
    }

    public Set<SocialLinkModel> getSocialLinks(UserModel userModel, RealmModel realm) {
        UserModel user = this.getUserById(userModel.getId(), realm);
        MongoUserEntity userEntity = ((UserAdapter)user).getUser();
        List linkEntities = userEntity.getSocialLinks();
        if (linkEntities == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<SocialLinkModel> result = new HashSet<SocialLinkModel>();
        for (SocialLinkEntity socialLinkEntity : linkEntities) {
            SocialLinkModel model = new SocialLinkModel(socialLinkEntity.getSocialProvider(), socialLinkEntity.getSocialUserId(), socialLinkEntity.getSocialUsername());
            result.add(model);
        }
        return result;
    }

    private SocialLinkEntity findSocialLink(UserModel userModel, String socialProvider, RealmModel realm) {
        UserModel user = this.getUserById(userModel.getId(), realm);
        MongoUserEntity userEntity = ((UserAdapter)user).getUser();
        List linkEntities = userEntity.getSocialLinks();
        if (linkEntities == null) {
            return null;
        }
        for (SocialLinkEntity socialLinkEntity : linkEntities) {
            if (!socialLinkEntity.getSocialProvider().equals(socialProvider)) continue;
            return socialLinkEntity;
        }
        return null;
    }

    public SocialLinkModel getSocialLink(UserModel user, String socialProvider, RealmModel realm) {
        SocialLinkEntity socialLinkEntity = this.findSocialLink(user, socialProvider, realm);
        return socialLinkEntity != null ? new SocialLinkModel(socialLinkEntity.getSocialProvider(), socialLinkEntity.getSocialUserId(), socialLinkEntity.getSocialUsername()) : null;
    }

    public UserAdapter addUser(RealmModel realm, String id, String username, boolean addDefaultRoles) {
        UserAdapter userModel = this.addUserEntity(realm, id, username);
        if (addDefaultRoles) {
            for (String r : realm.getDefaultRoles()) {
                userModel.grantRole(realm.getRole(r));
            }
            for (ApplicationModel application : realm.getApplications()) {
                for (String r : application.getDefaultRoles()) {
                    userModel.grantRole(application.getRole(r));
                }
            }
        }
        return userModel;
    }

    protected UserAdapter addUserEntity(RealmModel realm, String id, String username) {
        MongoUserEntity userEntity = new MongoUserEntity();
        userEntity.setId(id);
        userEntity.setUsername(username);
        userEntity.setRealmId(realm.getId());
        this.getMongoStore().insertEntity((MongoIdentifiableEntity)userEntity, this.invocationContext);
        return new UserAdapter(this.session, realm, userEntity, this.invocationContext);
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        DBObject query = new QueryBuilder().and("_id").is((Object)user.getId()).and("realmId").is((Object)realm.getId()).get();
        return this.getMongoStore().removeEntities(MongoUserEntity.class, query, this.invocationContext);
    }

    public void addSocialLink(RealmModel realm, UserModel user, SocialLinkModel socialLink) {
        user = this.getUserById(user.getId(), realm);
        MongoUserEntity userEntity = ((UserAdapter)user).getUser();
        SocialLinkEntity socialLinkEntity = new SocialLinkEntity();
        socialLinkEntity.setSocialProvider(socialLink.getSocialProvider());
        socialLinkEntity.setSocialUserId(socialLink.getSocialUserId());
        socialLinkEntity.setSocialUsername(socialLink.getSocialUsername());
        this.getMongoStore().pushItemToList((MongoIdentifiableEntity)userEntity, "socialLinks", (Object)socialLinkEntity, true, this.invocationContext);
    }

    public boolean removeSocialLink(RealmModel realm, UserModel userModel, String socialProvider) {
        UserModel user = this.getUserById(userModel.getId(), realm);
        MongoUserEntity userEntity = ((UserAdapter)user).getUser();
        SocialLinkEntity socialLinkEntity = this.findSocialLink(userEntity, socialProvider);
        if (socialLinkEntity == null) {
            return false;
        }
        return this.getMongoStore().pullItemFromList((MongoIdentifiableEntity)userEntity, "socialLinks", (Object)socialLinkEntity, this.invocationContext);
    }

    private SocialLinkEntity findSocialLink(MongoUserEntity userEntity, String socialProvider) {
        List linkEntities = userEntity.getSocialLinks();
        if (linkEntities == null) {
            return null;
        }
        for (SocialLinkEntity socialLinkEntity : linkEntities) {
            if (!socialLinkEntity.getSocialProvider().equals(socialProvider)) continue;
            return socialLinkEntity;
        }
        return null;
    }

    public UserModel addUser(RealmModel realm, String username) {
        return this.addUser(realm, null, username, true);
    }

    public void preRemove(RealmModel realm) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)realm.getId()).get();
        this.getMongoStore().removeEntities(MongoUserEntity.class, query, this.invocationContext);
    }

    public void preRemove(RealmModel realm, UserFederationProviderModel link) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)realm.getId()).and("federationLink").is((Object)link.getId()).get();
        this.getMongoStore().removeEntities(MongoUserEntity.class, query, this.invocationContext);
    }

    public void preRemove(RealmModel realm, RoleModel role) {
    }

    public boolean validCredentials(RealmModel realm, UserModel user, List<UserCredentialModel> input) {
        return CredentialValidation.validCredentials((RealmModel)realm, (UserModel)user, input);
    }

    public boolean validCredentials(RealmModel realm, UserModel user, UserCredentialModel ... input) {
        return CredentialValidation.validCredentials((RealmModel)realm, (UserModel)user, (UserCredentialModel[])input);
    }
}

