/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;

public class AuthRequest {
    private URI authUri;

    public static AuthRequestBuilder create(String url) {
        AuthRequestBuilder req = new AuthRequestBuilder();
        req.b = new StringBuilder();
        req.b.append(url);
        return req;
    }

    private AuthRequest(URI authUri) {
        this.authUri = authUri;
    }

    public URI getAuthUri() {
        return this.authUri;
    }

    public static class AuthRequestBuilder {
        private StringBuilder b;
        private char sep = (char)63;
        private String id;

        private AuthRequestBuilder() {
        }

        public AuthRequestBuilder setQueryParam(String name, String value) {
            try {
                if (this.sep == '?') {
                    this.b.append(this.sep);
                    this.sep = (char)38;
                } else {
                    this.b.append(this.sep);
                }
                this.b.append(URLEncoder.encode(name, "UTF-8"));
                this.b.append("=");
                this.b.append(URLEncoder.encode(value, "UTF-8"));
                return this;
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }

        public AuthRequest build() {
            try {
                return new AuthRequest(new URI(this.b.toString()));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

