/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.util.Sessions;
import org.jboss.logging.Logger;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.KeycloakAccount;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.undertow.AbstractUndertowRequestAuthenticator;
import org.keycloak.adapters.undertow.KeycloakUndertowAccount;
import org.keycloak.adapters.undertow.UndertowUserSessionManagement;

public class UndertowSessionTokenStore
implements AdapterTokenStore {
    protected static Logger log = Logger.getLogger(UndertowSessionTokenStore.class);
    private final HttpServerExchange exchange;
    private final KeycloakDeployment deployment;
    private final UndertowUserSessionManagement sessionManagement;
    private final SecurityContext securityContext;

    public UndertowSessionTokenStore(HttpServerExchange exchange, KeycloakDeployment deployment, UndertowUserSessionManagement sessionManagement, SecurityContext securityContext) {
        this.exchange = exchange;
        this.deployment = deployment;
        this.sessionManagement = sessionManagement;
        this.securityContext = securityContext;
    }

    public void checkCurrentToken() {
    }

    public boolean isCached(RequestAuthenticator authenticator) {
        Session session = Sessions.getSession((HttpServerExchange)this.exchange);
        if (session == null) {
            log.debug((Object)"session was null, returning null");
            return false;
        }
        KeycloakUndertowAccount account = (KeycloakUndertowAccount)session.getAttribute(KeycloakUndertowAccount.class.getName());
        if (account == null) {
            log.debug((Object)"Account was not in session, returning null");
            return false;
        }
        if (!this.deployment.getRealm().equals(account.getKeycloakSecurityContext().getRealm())) {
            log.debug((Object)"Account in session belongs to a different realm than for this request.");
            return false;
        }
        account.setCurrentRequestInfo(this.deployment, this);
        if (account.checkActive()) {
            log.debug((Object)"Cached account found");
            this.securityContext.authenticationComplete((Account)account, "KEYCLOAK", false);
            ((AbstractUndertowRequestAuthenticator)authenticator).propagateKeycloakContext(account);
            return true;
        }
        log.debug((Object)"Account was not active, returning false");
        session.removeAttribute(KeycloakUndertowAccount.class.getName());
        session.invalidate(this.exchange);
        return false;
    }

    public void saveRequest() {
    }

    public boolean restoreRequest() {
        return false;
    }

    public void saveAccountInfo(KeycloakAccount account) {
        Session session = Sessions.getOrCreateSession((HttpServerExchange)this.exchange);
        session.setAttribute(KeycloakUndertowAccount.class.getName(), (Object)account);
        this.sessionManagement.login(session.getSessionManager());
    }

    public void logout() {
        Session session = Sessions.getSession((HttpServerExchange)this.exchange);
        if (session == null) {
            return;
        }
        KeycloakUndertowAccount account = (KeycloakUndertowAccount)session.getAttribute(KeycloakUndertowAccount.class.getName());
        if (account == null) {
            return;
        }
        session.removeAttribute(KeycloakUndertowAccount.class.getName());
    }

    public void refreshCallback(RefreshableKeycloakSecurityContext securityContext) {
    }
}

