/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.util.Sessions;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakAccount;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OAuthRequestAuthenticator;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.undertow.KeycloakUndertowAccount;
import org.keycloak.adapters.undertow.UndertowHttpFacade;
import org.keycloak.adapters.undertow.UndertowUserSessionManagement;

public abstract class UndertowRequestAuthenticator
extends RequestAuthenticator {
    protected SecurityContext securityContext;
    protected HttpServerExchange exchange;
    protected UndertowUserSessionManagement userSessionManagement;

    public UndertowRequestAuthenticator(HttpFacade facade, KeycloakDeployment deployment, int sslRedirectPort, SecurityContext securityContext, HttpServerExchange exchange, UndertowUserSessionManagement userSessionManagement) {
        super(facade, deployment, sslRedirectPort);
        this.securityContext = securityContext;
        this.exchange = exchange;
        this.userSessionManagement = userSessionManagement;
    }

    protected void propagateKeycloakContext(KeycloakUndertowAccount account) {
        this.exchange.putAttachment(UndertowHttpFacade.KEYCLOAK_SECURITY_CONTEXT_KEY, (Object)account.getKeycloakSecurityContext());
    }

    protected OAuthRequestAuthenticator createOAuthAuthenticator() {
        return new OAuthRequestAuthenticator(this.facade, this.deployment, this.sslRedirectPort){

            protected void saveRequest() {
            }
        };
    }

    protected void completeOAuthAuthentication(KeycloakPrincipal principal, RefreshableKeycloakSecurityContext session) {
        KeycloakUndertowAccount account = this.createAccount(principal, session);
        this.securityContext.authenticationComplete((Account)account, "KEYCLOAK", false);
        this.propagateKeycloakContext(account);
        this.login(account);
    }

    protected void login(KeycloakAccount account) {
        Session session = Sessions.getOrCreateSession((HttpServerExchange)this.exchange);
        session.setAttribute(KeycloakUndertowAccount.class.getName(), (Object)account);
        String username = account.getPrincipal().getName();
        String keycloakSessionId = account.getKeycloakSecurityContext().getToken().getSessionState();
        this.userSessionManagement.login(session.getSessionManager(), session.getId(), username, keycloakSessionId);
    }

    protected void completeBearerAuthentication(KeycloakPrincipal principal, RefreshableKeycloakSecurityContext session) {
        KeycloakUndertowAccount account = this.createAccount(principal, session);
        this.securityContext.authenticationComplete((Account)account, "KEYCLOAK", false);
        this.propagateKeycloakContext(account);
    }

    protected boolean isCached() {
        Session session = Sessions.getSession((HttpServerExchange)this.exchange);
        if (session == null) {
            log.info((Object)"session was null, returning null");
            return false;
        }
        KeycloakUndertowAccount account = (KeycloakUndertowAccount)session.getAttribute(KeycloakUndertowAccount.class.getName());
        if (account == null) {
            log.info((Object)"Account was not in session, returning null");
            return false;
        }
        account.setDeployment(this.deployment);
        if (account.isActive()) {
            log.info((Object)"Cached account found");
            this.securityContext.authenticationComplete((Account)account, "KEYCLOAK", false);
            this.propagateKeycloakContext(account);
            return true;
        }
        log.info((Object)"Account was not active, returning false");
        session.removeAttribute(KeycloakUndertowAccount.class.getName());
        return false;
    }

    protected abstract KeycloakUndertowAccount createAccount(KeycloakPrincipal var1, RefreshableKeycloakSecurityContext var2);
}

