/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.elytron;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OidcKeycloakAccount;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;

public class ElytronAccount
implements Serializable,
OidcKeycloakAccount {
    private static final long serialVersionUID = -6775274346765339292L;
    protected static Logger log = Logger.getLogger(ElytronAccount.class);
    private final KeycloakPrincipal<RefreshableKeycloakSecurityContext> principal;

    public ElytronAccount(KeycloakPrincipal<RefreshableKeycloakSecurityContext> principal) {
        this.principal = principal;
    }

    public RefreshableKeycloakSecurityContext getKeycloakSecurityContext() {
        return (RefreshableKeycloakSecurityContext)this.principal.getKeycloakSecurityContext();
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Set<String> getRoles() {
        HashSet<String> roles = new HashSet<String>();
        return roles;
    }

    void setCurrentRequestInfo(KeycloakDeployment deployment, AdapterTokenStore tokenStore) {
        ((RefreshableKeycloakSecurityContext)this.principal.getKeycloakSecurityContext()).setCurrentRequestInfo(deployment, tokenStore);
    }

    public boolean checkActive() {
        RefreshableKeycloakSecurityContext session = this.getKeycloakSecurityContext();
        if (session.isActive() && !session.getDeployment().isAlwaysRefreshToken()) {
            log.debug((Object)"session is active");
            return true;
        }
        log.debug((Object)"session not active");
        return false;
    }

    boolean tryRefresh() {
        log.debug((Object)"Trying to refresh");
        RefreshableKeycloakSecurityContext securityContext = this.getKeycloakSecurityContext();
        if (securityContext == null) {
            log.debug((Object)"No security context. Aborting refresh.");
        }
        if (securityContext.refreshExpiredToken(false)) {
            log.debug((Object)"refresh succeeded");
            return true;
        }
        return this.checkActive();
    }
}

