/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.elytron;

import javax.security.auth.callback.CallbackHandler;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.AdapterUtils;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OidcKeycloakAccount;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.elytron.ElytronAccount;
import org.keycloak.adapters.elytron.ElytronHttpFacade;
import org.keycloak.adapters.elytron.ElytronTokeStore;
import org.keycloak.representations.AccessToken;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpScopeNotification;
import org.wildfly.security.http.Scope;

public class ElytronSessionTokenStore
implements ElytronTokeStore {
    private static Logger log = Logger.getLogger(ElytronSessionTokenStore.class);
    private final ElytronHttpFacade httpFacade;
    private final CallbackHandler callbackHandler;

    public ElytronSessionTokenStore(ElytronHttpFacade httpFacade, CallbackHandler callbackHandler) {
        this.httpFacade = httpFacade;
        this.callbackHandler = callbackHandler;
    }

    public void checkCurrentToken() {
        HttpScope session = this.httpFacade.getScope(Scope.SESSION);
        if (!session.exists()) {
            return;
        }
        RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)session.getAttachment(KeycloakSecurityContext.class.getName());
        if (securityContext == null) {
            return;
        }
        if (securityContext.getDeployment() == null) {
            securityContext.setCurrentRequestInfo(this.httpFacade.getDeployment(), (AdapterTokenStore)this);
        }
        if (securityContext.isActive() && !securityContext.getDeployment().isAlwaysRefreshToken()) {
            return;
        }
        boolean success = securityContext.refreshExpiredToken(false);
        if (success && securityContext.isActive()) {
            return;
        }
        session.setAttachment(KeycloakSecurityContext.class.getName(), null);
        session.invalidate();
    }

    public boolean isCached(RequestAuthenticator authenticator) {
        ElytronAccount account;
        HttpScope session = this.httpFacade.getScope(Scope.SESSION);
        if (session == null || !session.supportsAttachments()) {
            log.debug((Object)"session was null, returning null");
            return false;
        }
        try {
            account = (ElytronAccount)session.getAttachment(ElytronAccount.class.getName());
        }
        catch (IllegalStateException e) {
            log.debug((Object)"session was invalidated.  Return false.");
            return false;
        }
        if (account == null) {
            log.debug((Object)"Account was not in session, returning null");
            return false;
        }
        KeycloakDeployment deployment = this.httpFacade.getDeployment();
        if (!deployment.getRealm().equals(account.getKeycloakSecurityContext().getRealm())) {
            log.debug((Object)"Account in session belongs to a different realm than for this request.");
            return false;
        }
        boolean active = account.checkActive();
        if (!active) {
            active = account.tryRefresh(this.callbackHandler);
        }
        if (active) {
            log.debug((Object)"Cached account found");
            this.restoreRequest();
            this.httpFacade.authenticationComplete(account, true);
            return true;
        }
        log.debug((Object)"Refresh failed. Account was not active. Returning null and invalidating Http session");
        try {
            session.setAttachment(KeycloakSecurityContext.class.getName(), null);
            session.setAttachment(ElytronAccount.class.getName(), null);
            session.invalidate();
        }
        catch (Exception e) {
            log.debug((Object)"Failed to invalidate session, might already be invalidated");
        }
        return false;
    }

    public void saveAccountInfo(OidcKeycloakAccount account) {
        HttpScope session = this.httpFacade.getScope(Scope.SESSION);
        if (!session.exists()) {
            session.create();
        }
        session.setAttachment(ElytronAccount.class.getName(), (Object)account);
        session.setAttachment(KeycloakSecurityContext.class.getName(), (Object)account.getKeycloakSecurityContext());
        session.registerForNotification(httpScopeNotification -> {
            if (!httpScopeNotification.isOfType(new Enum[]{HttpScopeNotification.SessionNotificationType.UNDEPLOY})) {
                this.logout();
            }
        });
        HttpScope scope = this.httpFacade.getScope(Scope.EXCHANGE);
        scope.setAttachment(KeycloakSecurityContext.class.getName(), (Object)account.getKeycloakSecurityContext());
    }

    public void logout() {
        this.logout(false);
    }

    public void refreshCallback(RefreshableKeycloakSecurityContext securityContext) {
        KeycloakPrincipal principal = new KeycloakPrincipal(AdapterUtils.getPrincipalName((KeycloakDeployment)this.httpFacade.getDeployment(), (AccessToken)securityContext.getToken()), (KeycloakSecurityContext)securityContext);
        this.saveAccountInfo(new ElytronAccount((KeycloakPrincipal<RefreshableKeycloakSecurityContext>)principal));
    }

    public void saveRequest() {
        this.httpFacade.suspendRequest();
    }

    public boolean restoreRequest() {
        return this.httpFacade.restoreRequest();
    }

    @Override
    public void logout(boolean glo) {
        HttpScope session = this.httpFacade.getScope(Scope.SESSION);
        if (!session.exists()) {
            return;
        }
        try {
            if (glo) {
                KeycloakSecurityContext ksc = (KeycloakSecurityContext)session.getAttachment(KeycloakSecurityContext.class.getName());
                if (ksc == null) {
                    return;
                }
                KeycloakDeployment deployment = this.httpFacade.getDeployment();
                if (!deployment.isBearerOnly() && ksc != null && ksc instanceof RefreshableKeycloakSecurityContext) {
                    ((RefreshableKeycloakSecurityContext)ksc).logout(deployment);
                }
            }
            session.setAttachment(KeycloakSecurityContext.class.getName(), null);
            session.setAttachment(ElytronAccount.class.getName(), null);
            session.invalidate();
        }
        catch (IllegalStateException ise) {
            log.debugf("Session %s logged-out already", (Object)session.getID());
        }
    }
}

