/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.elytron;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.KeycloakConfigResolver;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;

public class KeycloakConfigurationServletListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
        AdapterDeploymentContext deploymentContext;
        ServletContext servletContext = sce.getServletContext();
        String configResolverClass = servletContext.getInitParameter("keycloak.config.resolver");
        if (configResolverClass != null) {
            try {
                KeycloakConfigResolver configResolver = (KeycloakConfigResolver)servletContext.getClassLoader().loadClass(configResolverClass).newInstance();
                deploymentContext = new AdapterDeploymentContext(configResolver);
            }
            catch (Exception ex) {
                deploymentContext = new AdapterDeploymentContext(new KeycloakDeployment());
            }
        } else {
            InputStream is = this.getConfigInputStream(servletContext);
            KeycloakDeployment deployment = is == null ? new KeycloakDeployment() : KeycloakDeploymentBuilder.build((InputStream)is);
            deploymentContext = new AdapterDeploymentContext(deployment);
        }
        servletContext.setAttribute(AdapterDeploymentContext.class.getName(), (Object)deploymentContext);
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    private InputStream getConfigInputStream(ServletContext servletContext) {
        InputStream is = this.getJSONFromServletContext(servletContext);
        if (is == null) {
            String path = servletContext.getInitParameter("keycloak.config.file");
            if (path == null) {
                is = servletContext.getResourceAsStream("/WEB-INF/keycloak.json");
            } else {
                try {
                    is = new FileInputStream(path);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return is;
    }

    private InputStream getJSONFromServletContext(ServletContext servletContext) {
        String json = servletContext.getInitParameter("org.keycloak.json.adapterConfig");
        if (json == null) {
            return null;
        }
        return new ByteArrayInputStream(json.getBytes());
    }
}

