/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.CookieTokenStore;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OidcKeycloakAccount;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.undertow.AbstractUndertowRequestAuthenticator;
import org.keycloak.adapters.undertow.KeycloakUndertowAccount;

public class UndertowCookieTokenStore
implements AdapterTokenStore {
    protected static Logger log = Logger.getLogger(UndertowCookieTokenStore.class);
    private final HttpFacade facade;
    private final KeycloakDeployment deployment;
    private final SecurityContext securityContext;

    public UndertowCookieTokenStore(HttpFacade facade, KeycloakDeployment deployment, SecurityContext securityContext) {
        this.facade = facade;
        this.deployment = deployment;
        this.securityContext = securityContext;
    }

    public void checkCurrentToken() {
    }

    public boolean isCached(RequestAuthenticator authenticator) {
        KeycloakPrincipal principal = CookieTokenStore.getPrincipalFromCookie((KeycloakDeployment)this.deployment, (HttpFacade)this.facade, (AdapterTokenStore)this);
        if (principal == null) {
            log.debug((Object)"Account was not in cookie or was invalid, returning null");
            return false;
        }
        KeycloakUndertowAccount account = new KeycloakUndertowAccount((KeycloakPrincipal<RefreshableKeycloakSecurityContext>)principal);
        if (!this.deployment.getRealm().equals(account.getKeycloakSecurityContext().getRealm())) {
            log.debug((Object)"Account in session belongs to a different realm than for this request.");
            return false;
        }
        if (account.checkActive()) {
            log.debug((Object)"Cached account found");
            this.securityContext.authenticationComplete((Account)account, "KEYCLOAK", false);
            ((AbstractUndertowRequestAuthenticator)authenticator).propagateKeycloakContext(account);
            return true;
        }
        log.debug((Object)"Account was not active, removing cookie and returning false");
        CookieTokenStore.removeCookie((HttpFacade)this.facade);
        return false;
    }

    public void saveAccountInfo(OidcKeycloakAccount account) {
        RefreshableKeycloakSecurityContext secContext = (RefreshableKeycloakSecurityContext)account.getKeycloakSecurityContext();
        CookieTokenStore.setTokenCookie((KeycloakDeployment)this.deployment, (HttpFacade)this.facade, (RefreshableKeycloakSecurityContext)secContext);
    }

    public void logout() {
        KeycloakPrincipal principal = CookieTokenStore.getPrincipalFromCookie((KeycloakDeployment)this.deployment, (HttpFacade)this.facade, (AdapterTokenStore)this);
        if (principal == null) {
            return;
        }
        CookieTokenStore.removeCookie((HttpFacade)this.facade);
    }

    public void refreshCallback(RefreshableKeycloakSecurityContext securityContext) {
        CookieTokenStore.setTokenCookie((KeycloakDeployment)this.deployment, (HttpFacade)this.facade, (RefreshableKeycloakSecurityContext)securityContext);
    }

    public void saveRequest() {
    }

    public boolean restoreRequest() {
        return false;
    }
}

