/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.elytron;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OidcKeycloakAccount;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.elytron.SecurityIdentityUtil;
import org.wildfly.security.auth.server.SecurityIdentity;

public class ElytronAccount
implements OidcKeycloakAccount {
    protected static Logger log = Logger.getLogger(ElytronAccount.class);
    private final KeycloakPrincipal<RefreshableKeycloakSecurityContext> principal;

    public ElytronAccount(KeycloakPrincipal<RefreshableKeycloakSecurityContext> principal) {
        this.principal = principal;
    }

    public RefreshableKeycloakSecurityContext getKeycloakSecurityContext() {
        return (RefreshableKeycloakSecurityContext)this.principal.getKeycloakSecurityContext();
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Set<String> getRoles() {
        HashSet<String> roles = new HashSet<String>();
        return roles;
    }

    void setCurrentRequestInfo(KeycloakDeployment deployment, AdapterTokenStore tokenStore) {
        ((RefreshableKeycloakSecurityContext)this.principal.getKeycloakSecurityContext()).setCurrentRequestInfo(deployment, tokenStore);
    }

    public boolean checkActive() {
        RefreshableKeycloakSecurityContext session = this.getKeycloakSecurityContext();
        if (session.isActive() && !session.getDeployment().isAlwaysRefreshToken()) {
            log.debug((Object)"session is active");
            return true;
        }
        log.debug((Object)"session not active");
        return false;
    }

    boolean tryRefresh(CallbackHandler callbackHandler) {
        log.debug((Object)"Trying to refresh");
        RefreshableKeycloakSecurityContext securityContext = this.getKeycloakSecurityContext();
        if (securityContext == null) {
            log.debug((Object)"No security context. Aborting refresh.");
        }
        if (securityContext.refreshExpiredToken(false)) {
            SecurityIdentity securityIdentity = SecurityIdentityUtil.authorize(callbackHandler, this.principal);
            if (securityIdentity != null) {
                log.debug((Object)"refresh succeeded");
                return true;
            }
            return false;
        }
        return this.checkActive();
    }
}

