/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client.resource;

import org.keycloak.authorization.client.representation.PermissionRequest;
import org.keycloak.authorization.client.representation.PermissionResponse;
import org.keycloak.authorization.client.util.Http;
import org.keycloak.authorization.client.util.Throwables;
import org.keycloak.util.JsonSerialization;

public class PermissionResource {
    private final Http http;
    private final String pat;

    public PermissionResource(Http http, String pat) {
        this.http = http;
        this.pat = pat;
    }

    public PermissionResponse forResource(PermissionRequest request) {
        try {
            return this.http.post("/authz/protection/permission").authorizationBearer(this.pat).json(JsonSerialization.writeValueAsBytes((Object)request)).response().json(PermissionResponse.class).execute();
        }
        catch (Exception cause) {
            throw Throwables.handleAndWrapException("Error obtaining permission ticket", cause);
        }
    }
}

