/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.elytron;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.servlet.handlers.ServletRequestContext;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.security.auth.callback.CallbackHandler;
import javax.security.cert.X509Certificate;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.OidcKeycloakAccount;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.elytron.ElytronAccount;
import org.keycloak.adapters.elytron.ElytronCookieTokenStore;
import org.keycloak.adapters.elytron.ElytronSessionTokenStore;
import org.keycloak.adapters.elytron.ElytronTokeStore;
import org.keycloak.adapters.elytron.ProtectedHttpServerExchange;
import org.keycloak.adapters.elytron.SecurityIdentityUtil;
import org.keycloak.adapters.spi.AuthChallenge;
import org.keycloak.adapters.spi.AuthenticationError;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.LogoutError;
import org.keycloak.enums.TokenStore;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpServerCookie;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.HttpServerResponse;
import org.wildfly.security.http.Scope;

class ElytronHttpFacade
implements OIDCHttpFacade {
    static final String UNDERTOW_EXCHANGE = ElytronHttpFacade.class.getName() + ".undertow.exchange";
    private final HttpServerRequest request;
    private final CallbackHandler callbackHandler;
    private final AdapterTokenStore tokenStore;
    private final AdapterDeploymentContext deploymentContext;
    private Consumer<HttpServerResponse> responseConsumer;
    private ElytronAccount account;
    private SecurityIdentity securityIdentity;
    private boolean restored;
    private final Map<String, String> headers = new HashMap<String, String>();

    public ElytronHttpFacade(HttpServerRequest request, AdapterDeploymentContext deploymentContext, CallbackHandler handler) {
        this.request = request;
        this.deploymentContext = deploymentContext;
        this.callbackHandler = handler;
        this.tokenStore = this.createTokenStore();
        this.responseConsumer = response -> {};
    }

    void authenticationComplete(ElytronAccount account, boolean storeToken) {
        this.securityIdentity = SecurityIdentityUtil.authorize(this.callbackHandler, account.getPrincipal());
        if (this.securityIdentity != null) {
            this.account = account;
            RefreshableKeycloakSecurityContext keycloakSecurityContext = account.getKeycloakSecurityContext();
            account.setCurrentRequestInfo(keycloakSecurityContext.getDeployment(), this.tokenStore);
            if (storeToken) {
                this.tokenStore.saveAccountInfo((OidcKeycloakAccount)account);
            }
        }
    }

    void authenticationComplete() {
        if (this.securityIdentity != null) {
            HttpScope requestScope = this.request.getScope(Scope.EXCHANGE);
            RefreshableKeycloakSecurityContext keycloakSecurityContext = this.account.getKeycloakSecurityContext();
            requestScope.setAttachment(KeycloakSecurityContext.class.getName(), (Object)keycloakSecurityContext);
            this.request.authenticationComplete(response -> {
                if (!this.restored) {
                    this.responseConsumer.accept(response);
                }
            }, () -> ((ElytronTokeStore)this.tokenStore).logout(true));
        }
    }

    void authenticationFailed() {
        this.request.authenticationFailed("Authentication Failed", response -> this.responseConsumer.accept(response));
    }

    void noAuthenticationInProgress() {
        this.request.noAuthenticationInProgress();
    }

    void noAuthenticationInProgress(AuthChallenge challenge) {
        if (challenge != null) {
            challenge.challenge((HttpFacade)this);
        }
        this.request.noAuthenticationInProgress(response -> this.responseConsumer.accept(response));
    }

    void authenticationInProgress() {
        this.request.authenticationInProgress(response -> this.responseConsumer.accept(response));
    }

    HttpScope getScope(Scope scope) {
        return this.request.getScope(scope);
    }

    HttpScope getScope(Scope scope, String id) {
        return this.request.getScope(scope, id);
    }

    Collection<String> getScopeIds(Scope scope) {
        return this.request.getScopeIds(scope);
    }

    AdapterTokenStore getTokenStore() {
        return this.tokenStore;
    }

    KeycloakDeployment getDeployment() {
        return this.deploymentContext.resolveDeployment((HttpFacade)this);
    }

    private AdapterTokenStore createTokenStore() {
        KeycloakDeployment deployment = this.getDeployment();
        if (TokenStore.SESSION.equals((Object)deployment.getTokenStore())) {
            return new ElytronSessionTokenStore(this, this.callbackHandler);
        }
        return new ElytronCookieTokenStore(this, this.callbackHandler);
    }

    public HttpFacade.Request getRequest() {
        return new HttpFacade.Request(){
            private InputStream inputStream;

            public String getMethod() {
                return ElytronHttpFacade.this.request.getRequestMethod();
            }

            public String getURI() {
                try {
                    return URLDecoder.decode(ElytronHttpFacade.this.request.getRequestURI().toString(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Failed to decode request URI", e);
                }
            }

            public String getRelativePath() {
                return ElytronHttpFacade.this.request.getRequestPath();
            }

            public boolean isSecure() {
                return ElytronHttpFacade.this.request.getRequestURI().getScheme().equals("https");
            }

            public String getFirstParam(String param) {
                return ElytronHttpFacade.this.request.getFirstParameterValue(param);
            }

            public String getQueryParamValue(String param) {
                URI requestURI = ElytronHttpFacade.this.request.getRequestURI();
                String query = requestURI.getQuery();
                if (query != null) {
                    String[] parameters;
                    for (String parameter : parameters = query.split("&")) {
                        String[] keyValue = parameter.split("=", 2);
                        if (!keyValue[0].equals(param)) continue;
                        try {
                            return URLDecoder.decode(keyValue[1], "UTF-8");
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to decode request URI", e);
                        }
                    }
                }
                return null;
            }

            public HttpFacade.Cookie getCookie(String cookieName) {
                List cookies = ElytronHttpFacade.this.request.getCookies();
                if (cookies != null) {
                    for (HttpServerCookie cookie : cookies) {
                        if (!cookie.getName().equals(cookieName)) continue;
                        return new HttpFacade.Cookie(cookie.getName(), cookie.getValue(), cookie.getVersion(), cookie.getDomain(), cookie.getPath());
                    }
                }
                return null;
            }

            public String getHeader(String name) {
                return ElytronHttpFacade.this.request.getFirstRequestHeaderValue(name);
            }

            public List<String> getHeaders(String name) {
                return ElytronHttpFacade.this.request.getRequestHeaderValues(name);
            }

            public InputStream getInputStream() {
                return this.getInputStream(false);
            }

            public InputStream getInputStream(boolean buffered) {
                if (this.inputStream != null) {
                    return this.inputStream;
                }
                if (buffered) {
                    HttpScope exchangeScope = ElytronHttpFacade.this.getScope(Scope.EXCHANGE);
                    HttpServerExchange exchange = ((ProtectedHttpServerExchange)ProtectedHttpServerExchange.class.cast(exchangeScope.getAttachment(UNDERTOW_EXCHANGE))).getExchange();
                    ServletRequestContext context = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                    ServletRequest servletRequest = context.getServletRequest();
                    this.inputStream = new BufferedInputStream(exchange.getInputStream());
                    context.setServletRequest((ServletRequest)new HttpServletRequestWrapper((HttpServletRequest)servletRequest){

                        public ServletInputStream getInputStream() {
                            inputStream.mark(0);
                            return new ServletInputStream(){

                                public int read() throws IOException {
                                    return inputStream.read();
                                }
                            };
                        }
                    });
                    return this.inputStream;
                }
                return ElytronHttpFacade.this.request.getInputStream();
            }

            public String getRemoteAddr() {
                InetSocketAddress sourceAddress = ElytronHttpFacade.this.request.getSourceAddress();
                if (sourceAddress == null) {
                    return "";
                }
                InetAddress address = sourceAddress.getAddress();
                if (address == null) {
                    return sourceAddress.getHostString();
                }
                return address.getHostAddress();
            }

            public void setError(AuthenticationError error) {
                ElytronHttpFacade.this.request.getScope(Scope.EXCHANGE).setAttachment(AuthenticationError.class.getName(), (Object)error);
            }

            public void setError(LogoutError error) {
                ElytronHttpFacade.this.request.getScope(Scope.EXCHANGE).setAttachment(LogoutError.class.getName(), (Object)error);
            }
        };
    }

    public HttpFacade.Response getResponse() {
        return new HttpFacade.Response(){

            public void setStatus(int status) {
                if (status < 200 || status > 300) {
                    ElytronHttpFacade.this.responseConsumer = ElytronHttpFacade.this.responseConsumer.andThen(response -> response.setStatusCode(status));
                }
            }

            public void addHeader(final String name, final String value) {
                ElytronHttpFacade.this.headers.put(name, value);
                ElytronHttpFacade.this.responseConsumer = ElytronHttpFacade.this.responseConsumer.andThen(new Consumer<HttpServerResponse>(){

                    @Override
                    public void accept(HttpServerResponse response) {
                        String latestValue = (String)ElytronHttpFacade.this.headers.get(name);
                        if (latestValue.equals(value)) {
                            response.addResponseHeader(name, latestValue);
                        }
                    }
                });
            }

            public void setHeader(String name, String value) {
                this.addHeader(name, value);
            }

            public void resetCookie(String name, String path) {
                ElytronHttpFacade.this.responseConsumer = ElytronHttpFacade.this.responseConsumer.andThen(response -> this.setCookie(name, "", path, null, 0, false, false, (HttpServerResponse)response));
                HttpScope exchangeScope = ElytronHttpFacade.this.getScope(Scope.EXCHANGE);
                ProtectedHttpServerExchange undertowExchange = (ProtectedHttpServerExchange)ProtectedHttpServerExchange.class.cast(exchangeScope.getAttachment(UNDERTOW_EXCHANGE));
                if (undertowExchange != null) {
                    CookieImpl cookie = new CookieImpl(name, "");
                    cookie.setMaxAge(Integer.valueOf(0));
                    cookie.setPath(path);
                    undertowExchange.getExchange().setResponseCookie((Cookie)cookie);
                }
            }

            public void setCookie(String name, String value, String path, String domain, int maxAge, boolean secure, boolean httpOnly) {
                ElytronHttpFacade.this.responseConsumer = ElytronHttpFacade.this.responseConsumer.andThen(response -> this.setCookie(name, value, path, domain, maxAge, secure, httpOnly, (HttpServerResponse)response));
            }

            private void setCookie(final String name, final String value, final String path, final String domain, final int maxAge, final boolean secure, final boolean httpOnly, HttpServerResponse response) {
                response.setResponseCookie(new HttpServerCookie(){

                    public String getName() {
                        return name;
                    }

                    public String getValue() {
                        return value;
                    }

                    public String getDomain() {
                        return domain;
                    }

                    public int getMaxAge() {
                        return maxAge;
                    }

                    public String getPath() {
                        return path;
                    }

                    public boolean isSecure() {
                        return secure;
                    }

                    public int getVersion() {
                        return 0;
                    }

                    public boolean isHttpOnly() {
                        return httpOnly;
                    }
                });
            }

            public OutputStream getOutputStream() {
                final ByteArrayOutputStream stream = new ByteArrayOutputStream();
                ElytronHttpFacade.this.responseConsumer = ElytronHttpFacade.this.responseConsumer.andThen(new Consumer<HttpServerResponse>(){

                    @Override
                    public void accept(HttpServerResponse httpServerResponse) {
                        try {
                            httpServerResponse.getOutputStream().write(stream.toByteArray());
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to write to response output stream", e);
                        }
                    }
                });
                return stream;
            }

            public void sendError(int code) {
                this.setStatus(code);
            }

            public void sendError(int code, String message) {
                ElytronHttpFacade.this.responseConsumer = ElytronHttpFacade.this.responseConsumer.andThen(response -> {
                    response.setStatusCode(code);
                    response.addResponseHeader("Content-Type", "text/html");
                    try {
                        response.getOutputStream().write(message.getBytes());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }

            public void end() {
            }
        };
    }

    public X509Certificate[] getCertificateChain() {
        return new X509Certificate[0];
    }

    public KeycloakSecurityContext getSecurityContext() {
        if (this.account == null) {
            return null;
        }
        return this.account.getKeycloakSecurityContext();
    }

    public boolean restoreRequest() {
        this.restored = this.request.resumeRequest();
        return this.restored;
    }

    public void suspendRequest() {
        this.responseConsumer = this.responseConsumer.andThen(httpServerResponse -> this.request.suspendRequest());
    }

    public boolean isAuthorized() {
        return this.securityIdentity != null;
    }
}

