/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.server.extension;

import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.keycloak.provider.KeycloakDeploymentInfo;
import org.keycloak.provider.ProviderManager;
import org.keycloak.provider.ProviderManagerRegistry;
import org.keycloak.subsystem.server.extension.KeycloakAdapterConfigService;
import org.keycloak.subsystem.server.extension.KeycloakProviderDependencyProcessor;
import org.keycloak.subsystem.server.extension.ScriptProviderDeploymentProcessor;

public class KeycloakProviderDeploymentProcessor
implements DeploymentUnitProcessor {
    AttachmentKey<ProviderManager> ATTACHMENT_KEY = AttachmentKey.create(ProviderManager.class);
    private static final Logger logger = Logger.getLogger(KeycloakProviderDeploymentProcessor.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        KeycloakAdapterConfigService config = KeycloakAdapterConfigService.INSTANCE;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        String deploymentName = deploymentUnit.getName();
        if (config.isKeycloakServerDeployment(deploymentName)) {
            return;
        }
        KeycloakDeploymentInfo info = KeycloakProviderDependencyProcessor.getKeycloakProviderDeploymentInfo(deploymentUnit);
        ScriptProviderDeploymentProcessor.deploy(deploymentUnit, info);
        if (info.isProvider()) {
            logger.infov("Deploying Keycloak provider: {0}", (Object)deploymentUnit.getName());
            Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
            ProviderManager pm = new ProviderManager(info, (ClassLoader)module.getClassLoader(), new String[0]);
            ProviderManagerRegistry.SINGLETON.deploy(pm);
            deploymentUnit.putAttachment(this.ATTACHMENT_KEY, (Object)pm);
        }
    }

    public void undeploy(DeploymentUnit context) {
        ProviderManager pm = (ProviderManager)context.getAttachment(this.ATTACHMENT_KEY);
        if (pm != null) {
            logger.infov("Undeploying Keycloak provider: {0}", (Object)context.getName());
            ProviderManagerRegistry.SINGLETON.undeploy(pm);
            context.removeAttachment(this.ATTACHMENT_KEY);
        }
    }
}

