/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ietf.jgss.GSSCredential;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.common.util.KerberosSerializationUtils;

public class KerberosCredDelegServlet
extends HttpServlet {
    public static final String CRED_DELEG_TEST_PATH = "/cred-deleg-test";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String ldapData = null;
        if (req.getRequestURI().endsWith(CRED_DELEG_TEST_PATH)) {
            try {
                KeycloakPrincipal keycloakPrincipal = (KeycloakPrincipal)req.getUserPrincipal();
                String serializedGssCredential = (String)keycloakPrincipal.getKeycloakSecurityContext().getToken().getOtherClaims().get("gss_delegation_credential");
                GSSCredential gssCredential = KerberosSerializationUtils.deserializeCredential((String)serializedGssCredential);
                try {
                    this.invokeLdap(null);
                    throw new RuntimeException("Not expected to authenticate to LDAP without credential");
                }
                catch (NamingException nse) {
                    System.out.println("Expected exception: " + nse.getMessage());
                    ldapData = this.invokeLdap(gssCredential);
                }
            }
            catch (KerberosSerializationUtils.KerberosSerializationException kse) {
                System.err.println("KerberosSerializationUtils.KerberosSerializationException: " + kse.getMessage());
                ldapData = "ERROR";
            }
            catch (Exception e) {
                e.printStackTrace();
                resp.sendError(500);
            }
        }
        resp.setContentType("text/html");
        PrintWriter pw = resp.getWriter();
        pw.printf("<html><head><title>%s</title></head><body>", "Kerberos Test");
        pw.printf("Kerberos servlet secured content<br>", new Object[0]);
        if (ldapData != null) {
            pw.printf("LDAP Data: " + ldapData + "<br>", new Object[0]);
        }
        pw.print("</body></html>");
        pw.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String invokeLdap(GSSCredential gssCredential) throws NamingException {
        Hashtable<String, Object> env = new Hashtable<String, Object>(11);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://localhost:10389");
        if (gssCredential != null) {
            env.put("java.naming.security.authentication", "GSSAPI");
            env.put("javax.security.sasl.credentials", gssCredential);
        }
        try (InitialDirContext ctx = new InitialDirContext(env);){
            Attributes attrs = ctx.getAttributes("uid=hnelson,ou=People,dc=keycloak,dc=org");
            String cn = (String)attrs.get("cn").get();
            String sn = (String)attrs.get("sn").get();
            String string = cn + " " + sn;
            return string;
        }
    }
}

