/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.testsuite.adapter.servlet.AbstractShowTokensServlet;

public class OfflineTokenServlet
extends AbstractShowTokensServlet {
    private static final String OFFLINE_CLIENT_APP_URI = System.getProperty("app.server.ssl.required", "false").equals("true") ? System.getProperty("app.server.ssl.base.url", "https://localhost:8643") + "/offline-client" : System.getProperty("app.server.base.url", "http://localhost:8280") + "/offline-client";
    private static final String ADAPTER_ROOT_URL = System.getProperty("auth.server.ssl.required", "false").equals("true") ? System.getProperty("auth.server.ssl.base.url", "https://localhost:8543") : System.getProperty("auth.server.base.url", "http://localhost:8180");

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getRequestURI().endsWith("logout")) {
            UriBuilder redirectUriBuilder = UriBuilder.fromUri((String)OFFLINE_CLIENT_APP_URI);
            if (req.getParameter("scope") != null) {
                redirectUriBuilder.queryParam("scope", new Object[]{req.getParameter("scope")});
            }
            String redirectUri = redirectUriBuilder.build(new Object[0]).toString();
            String serverLogoutRedirect = UriBuilder.fromUri((String)(ADAPTER_ROOT_URL + "/auth/realms/test/protocol/openid-connect/logout")).queryParam("redirect_uri", new Object[]{redirectUri}).build(new Object[0]).toString();
            resp.sendRedirect(serverLogoutRedirect);
            return;
        }
        StringBuilder response = new StringBuilder("<html><head><title>Offline token servlet</title></head><body><pre>");
        String tokens = this.renderTokens(req);
        response = response.append(tokens);
        response.append("</pre></body></html>");
        resp.getWriter().println(response.toString());
    }
}

