/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.annotation.ClassScoped;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.jboss.logging.Logger;
import org.keycloak.testsuite.arquillian.AuthServerTestEnricher;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.arquillian.TestContext;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;

public class AppServerTestEnricher {
    protected final Logger log = Logger.getLogger(this.getClass());
    @Inject
    @ClassScoped
    private InstanceProducer<TestContext> testContextProducer;
    private TestContext testContext;
    @Inject
    private Instance<ContainerController> containerConrollerInstance;

    public static String getAppServerQualifier(Class testClass) {
        String appServerQ;
        Class annotatedClass = AppServerTestEnricher.getNearestSuperclassWithAnnotation(testClass, AppServerContainer.class);
        String string = appServerQ = annotatedClass == null ? null : annotatedClass.getAnnotation(AppServerContainer.class).value();
        return annotatedClass == null ? null : (appServerQ == null || appServerQ.isEmpty() ? AuthServerTestEnricher.AUTH_SERVER_CONTAINER : appServerQ);
    }

    public static String getAppServerContextRoot() {
        return AppServerTestEnricher.getAppServerContextRoot(0);
    }

    public static String getAppServerContextRoot(int clusterPortOffset) {
        String host = System.getProperty("app.server.host", "localhost");
        int httpPort = Integer.parseInt(System.getProperty("app.server.http.port"));
        int httpsPort = Integer.parseInt(System.getProperty("app.server.https.port"));
        boolean sslRequired = Boolean.parseBoolean(System.getProperty("app.server.ssl.required"));
        String scheme = sslRequired ? "https" : "http";
        int port = sslRequired ? httpsPort : httpPort;
        return String.format("%s://%s:%s", scheme, host, port + clusterPortOffset);
    }

    public void updateTestContextWithAppServerInfo(@Observes(precedence=1) BeforeClass event) {
        this.testContext = (TestContext)this.testContextProducer.get();
        String appServerQualifier = AppServerTestEnricher.getAppServerQualifier(this.testContext.getTestClass());
        for (ContainerInfo container : this.testContext.getSuiteContext().getContainers()) {
            if (!container.getQualifier().equals(appServerQualifier)) continue;
            this.testContext.setAppServerInfo(this.updateWithAppServerInfo(container));
        }
        if (appServerQualifier != null && this.testContext.getAppServerInfo() == null) {
            throw new RuntimeException(String.format("No app server container matching '%s' was activated. Check if defined and enabled in arquillian.xml.", appServerQualifier));
        }
        this.log.info((Object)("\n\n" + this.testContext));
    }

    private ContainerInfo updateWithAppServerInfo(ContainerInfo appServerInfo) {
        return this.updateWithAppServerInfo(appServerInfo, 0);
    }

    private ContainerInfo updateWithAppServerInfo(ContainerInfo appServerInfo, int clusterPortOffset) {
        try {
            String appServerContextRootStr = AppServerTestEnricher.isRelative(this.testContext.getTestClass()) ? AuthServerTestEnricher.getAuthServerContextRoot(clusterPortOffset) : AppServerTestEnricher.getAppServerContextRoot(clusterPortOffset);
            appServerInfo.setContextRoot(new URL(appServerContextRootStr));
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
        return appServerInfo;
    }

    public void startAppServer(@Observes(precedence=-1) BeforeClass event) throws MalformedURLException, InterruptedException, IOException {
        ContainerController controller;
        if (this.testContext.isAdapterTest() && !this.testContext.isRelativeAdapterTest() && !(controller = (ContainerController)this.containerConrollerInstance.get()).isStarted(this.testContext.getAppServerInfo().getQualifier())) {
            this.log.info((Object)("Starting app server: " + this.testContext.getAppServerInfo().getQualifier()));
            controller.start(this.testContext.getAppServerInfo().getQualifier());
        }
    }

    public static Class getNearestSuperclassWithAnnotation(Class testClass, Class annotationClass) {
        return testClass.isAnnotationPresent(annotationClass) ? testClass : (testClass.getSuperclass().equals(Object.class) ? null : AppServerTestEnricher.getNearestSuperclassWithAnnotation(testClass.getSuperclass(), annotationClass));
    }

    public static boolean hasAppServerContainerAnnotation(Class testClass) {
        return AppServerTestEnricher.getNearestSuperclassWithAnnotation(testClass, AppServerContainer.class) != null;
    }

    public static boolean isRelative(Class testClass) {
        return AppServerTestEnricher.getAppServerQualifier(testClass).equals(AuthServerTestEnricher.AUTH_SERVER_CONTAINER);
    }

    public static boolean isWildflyAppServer(Class testClass) {
        return AppServerTestEnricher.getAppServerQualifier(testClass).contains("wildfly");
    }

    public static boolean isTomcatAppServer(Class testClass) {
        return AppServerTestEnricher.getAppServerQualifier(testClass).contains("tomcat");
    }

    public static boolean isOSGiAppServer(Class testClass) {
        String q = AppServerTestEnricher.getAppServerQualifier(testClass);
        return q.contains("karaf") || q.contains("fuse");
    }
}

