/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian;

import java.net.URL;
import java.util.Map;
import java.util.Objects;
import org.jboss.arquillian.container.spi.Container;

public class ContainerInfo {
    private URL contextRoot;
    private Container arquillianContainer;
    private boolean adapterLibsInstalled;

    public ContainerInfo(Container arquillianContainer) {
        if (arquillianContainer == null) {
            throw new IllegalArgumentException();
        }
        this.arquillianContainer = arquillianContainer;
    }

    public Container getArquillianContainer() {
        return this.arquillianContainer;
    }

    public Map<String, String> getProperties() {
        return this.getArquillianContainer().getContainerConfiguration().getContainerProperties();
    }

    public String getQualifier() {
        return this.getArquillianContainer().getName();
    }

    public URL getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(URL contextRoot) {
        this.contextRoot = contextRoot;
    }

    public boolean isAS7() {
        return this.getQualifier().toLowerCase().contains("as7");
    }

    public boolean isWildfly() {
        return this.getQualifier().toLowerCase().contains("wildfly");
    }

    public boolean isEAP() {
        return this.getQualifier().toLowerCase().contains("eap");
    }

    public boolean isJBossBased() {
        return this.isAS7() || this.isWildfly() || this.isEAP();
    }

    public String toString() {
        return this.getQualifier();
    }

    public boolean isAdapterLibsInstalled() {
        return this.adapterLibsInstalled;
    }

    public void setAdapterLibsInstalled(boolean adapterLibsInstalled) {
        this.adapterLibsInstalled = adapterLibsInstalled;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.arquillianContainer);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerInfo other = (ContainerInfo)obj;
        return Objects.equals(this.arquillianContainer.getContainerConfiguration().getContainerName(), other.arquillianContainer.getContainerConfiguration().getContainerName());
    }
}

