/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.testsuite.arquillian.AppServerTestEnricher;
import org.keycloak.testsuite.arquillian.AuthServerTestEnricher;
import org.keycloak.testsuite.arquillian.SAMLFilterDependency;
import org.keycloak.testsuite.arquillian.annotation.UseServletFilter;
import org.keycloak.testsuite.util.IOUtil;
import org.keycloak.util.JsonSerialization;
import org.w3c.dom.Document;

public class DeploymentArchiveProcessor
implements ApplicationArchiveProcessor {
    public static final String REALM_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQAB";
    protected final Logger log = Logger.getLogger(this.getClass());
    private final boolean authServerSslRequired = Boolean.parseBoolean(System.getProperty("auth.server.ssl.required"));
    public static final String WEBXML_PATH = "/WEB-INF/web.xml";
    public static final String ADAPTER_CONFIG_PATH = "/WEB-INF/keycloak.json";
    public static final String ADAPTER_CONFIG_PATH_TENANT1 = "/WEB-INF/classes/tenant1-keycloak.json";
    public static final String ADAPTER_CONFIG_PATH_TENANT2 = "/WEB-INF/classes/tenant2-keycloak.json";
    public static final String ADAPTER_CONFIG_PATH_JS = "/keycloak.json";
    public static final String SAML_ADAPTER_CONFIG_PATH = "/WEB-INF/keycloak-saml.xml";
    DirectoryScanner scanner = new DirectoryScanner();

    public void process(Archive<?> archive, TestClass testClass) {
        this.log.info((Object)("Processing archive " + archive.getName()));
        this.modifyAdapterConfigs(archive, testClass);
        this.modifyWebXml(archive, testClass);
    }

    public static boolean isAdapterTest(TestClass testClass) {
        return AppServerTestEnricher.hasAppServerContainerAnnotation(testClass.getJavaClass());
    }

    protected void modifyAdapterConfigs(Archive<?> archive, TestClass testClass) {
        boolean relative = AppServerTestEnricher.isRelative(testClass.getJavaClass());
        this.modifyAdapterConfig(archive, ADAPTER_CONFIG_PATH, relative);
        this.modifyAdapterConfig(archive, ADAPTER_CONFIG_PATH_TENANT1, relative);
        this.modifyAdapterConfig(archive, ADAPTER_CONFIG_PATH_TENANT2, relative);
        this.modifyAdapterConfig(archive, ADAPTER_CONFIG_PATH_JS, relative);
        this.modifyAdapterConfig(archive, SAML_ADAPTER_CONFIG_PATH, relative);
    }

    protected void modifyAdapterConfig(Archive<?> archive, String adapterConfigPath, boolean relative) {
        if (archive.contains(adapterConfigPath)) {
            this.log.info((Object)("Modifying adapter config " + adapterConfigPath + " in " + archive.getName()));
            if (adapterConfigPath.equals(SAML_ADAPTER_CONFIG_PATH)) {
                this.log.info((Object)("Modyfying saml adapter config in " + archive.getName()));
                Document doc = IOUtil.loadXML(archive.get("WEB-INF/keycloak-saml.xml").getAsset().openStream());
                if (this.authServerSslRequired) {
                    IOUtil.modifyDocElementAttribute(doc, "SingleSignOnService", "bindingUrl", "8080", System.getProperty("auth.server.https.port"));
                    IOUtil.modifyDocElementAttribute(doc, "SingleSignOnService", "bindingUrl", "http", "https");
                    IOUtil.modifyDocElementAttribute(doc, "SingleLogoutService", "postBindingUrl", "8080", System.getProperty("auth.server.https.port"));
                    IOUtil.modifyDocElementAttribute(doc, "SingleLogoutService", "postBindingUrl", "http", "https");
                    IOUtil.modifyDocElementAttribute(doc, "SingleLogoutService", "redirectBindingUrl", "8080", System.getProperty("auth.server.https.port"));
                    IOUtil.modifyDocElementAttribute(doc, "SingleLogoutService", "redirectBindingUrl", "http", "https");
                } else {
                    IOUtil.modifyDocElementAttribute(doc, "SingleSignOnService", "bindingUrl", "8080", System.getProperty("auth.server.http.port"));
                    IOUtil.modifyDocElementAttribute(doc, "SingleLogoutService", "postBindingUrl", "8080", System.getProperty("auth.server.http.port"));
                    IOUtil.modifyDocElementAttribute(doc, "SingleLogoutService", "redirectBindingUrl", "8080", System.getProperty("auth.server.http.port"));
                }
                try {
                    archive.add((Asset)new StringAsset(IOUtil.documentToString(doc)), adapterConfigPath);
                }
                catch (TransformerException e) {
                    this.log.error((Object)"Can't transform document to String");
                    throw new RuntimeException(e);
                }
            }
            try {
                AdapterConfig adapterConfig = IOUtil.loadJson(archive.get(adapterConfigPath).getAsset().openStream(), AdapterConfig.class);
                this.log.info((Object)(" setting " + (relative ? "" : "non-") + "relative auth-server-url"));
                if (relative) {
                    adapterConfig.setAuthServerUrl("/auth");
                } else {
                    adapterConfig.setAuthServerUrl(AuthServerTestEnricher.getAuthServerContextRoot() + "/auth");
                    adapterConfig.setRealmKey(REALM_KEY);
                }
                if ("true".equals(System.getProperty("app.server.ssl.required"))) {
                    adapterConfig.setSslRequired("all");
                }
                archive.add((Asset)new StringAsset(JsonSerialization.writeValueAsPrettyString((Object)adapterConfig)), adapterConfigPath);
            }
            catch (IOException ex) {
                this.log.log(Logger.Level.FATAL, (Object)"Cannot serialize adapter config to JSON.", (Throwable)ex);
            }
        }
    }

    protected List<File> getAdapterLibs(File adapterLibsLocation) {
        assert (adapterLibsLocation.exists());
        ArrayList<File> libs = new ArrayList<File>();
        this.scanner.setBasedir(adapterLibsLocation);
        this.scanner.setIncludes(new String[]{"**/*jar"});
        this.scanner.scan();
        for (String lib : this.scanner.getIncludedFiles()) {
            libs.add(new File(adapterLibsLocation, lib));
        }
        return libs;
    }

    protected void modifyWebXml(Archive<?> archive, TestClass testClass) {
        try {
            String webXmlContent = IOUtils.toString((InputStream)archive.get(WEBXML_PATH).getAsset().openStream());
            if (AppServerTestEnricher.isTomcatAppServer(testClass.getJavaClass())) {
                webXmlContent = webXmlContent.replace("<auth-method>KEYCLOAK</auth-method>", "<auth-method>BASIC</auth-method>");
            }
            if (testClass.getJavaClass().isAnnotationPresent(UseServletFilter.class)) {
                this.log.info((Object)("Adding filter to " + ((UseServletFilter)testClass.getAnnotation(UseServletFilter.class)).filterClass() + " with mapping " + ((UseServletFilter)testClass.getAnnotation(UseServletFilter.class)).filterPattern() + " for " + archive.getName()));
                String filter = "\n<filter>\n<filter-name>" + ((UseServletFilter)testClass.getAnnotation(UseServletFilter.class)).filterName() + "</filter-name>\n" + "<filter-class>" + ((UseServletFilter)testClass.getAnnotation(UseServletFilter.class)).filterClass() + "</filter-class>\n" + "</filter>\n" + "\n<filter-mapping>\n" + "<filter-name>" + ((UseServletFilter)testClass.getAnnotation(UseServletFilter.class)).filterName() + "</filter-name>\n" + "<url-pattern>" + ((UseServletFilter)testClass.getAnnotation(UseServletFilter.class)).filterPattern() + "</url-pattern>\n";
                if (!((UseServletFilter)testClass.getAnnotation(UseServletFilter.class)).dispatcherType().isEmpty()) {
                    filter = filter + "<dispatcher>" + ((UseServletFilter)testClass.getAnnotation(UseServletFilter.class)).dispatcherType() + "</dispatcher>\n";
                }
                filter = filter + "</filter-mapping>\n";
                webXmlContent = webXmlContent.replace("</module-name>", "</module-name> " + filter);
                this.log.info((Object)("Adding SAMLFilter dependencies to " + archive.getName()));
                ((WebArchive)archive).addAsLibraries(new SAMLFilterDependency().getDependencies());
                int start = webXmlContent.indexOf("<security-constraint>");
                int end = webXmlContent.indexOf("</security-role>") + "</security-role>".length();
                webXmlContent = webXmlContent.substring(0, start) + webXmlContent.substring(end);
            }
            archive.add((Asset)new StringAsset(webXmlContent), WEBXML_PATH);
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot load web.xml from archive.");
        }
    }
}

