/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.arquillian.SuiteContext;

public final class TestContext {
    private final SuiteContext suiteContext;
    private final Class testClass;
    private ContainerInfo appServerInfo;
    private final List<ContainerInfo> appServerBackendsInfo = new ArrayList<ContainerInfo>();
    private boolean adminLoggedIn;
    private final Map customContext = new HashMap();

    public TestContext(SuiteContext suiteContext, Class testClass) {
        this.suiteContext = suiteContext;
        this.testClass = testClass;
        this.adminLoggedIn = false;
    }

    public boolean isAdminLoggedIn() {
        return this.adminLoggedIn;
    }

    public void setAdminLoggedIn(boolean adminLoggedIn) {
        this.adminLoggedIn = adminLoggedIn;
    }

    public ContainerInfo getAppServerInfo() {
        return this.appServerInfo;
    }

    public void setAppServerInfo(ContainerInfo appServerInfo) {
        this.appServerInfo = appServerInfo;
    }

    public List<ContainerInfo> getAppServerBackendsInfo() {
        return this.appServerBackendsInfo;
    }

    public Class getTestClass() {
        return this.testClass;
    }

    public boolean isAdapterTest() {
        return this.appServerInfo != null;
    }

    public boolean isRelativeAdapterTest() {
        return this.isAdapterTest() && this.appServerInfo.getQualifier().equals(this.suiteContext.getAuthServerInfo().getQualifier());
    }

    public boolean isClusteredAdapterTest() {
        return this.isAdapterTest() && !this.appServerBackendsInfo.isEmpty();
    }

    public SuiteContext getSuiteContext() {
        return this.suiteContext;
    }

    public String toString() {
        return "TEST CONTEXT: " + this.getTestClass().getCanonicalName() + "\n" + (this.isAdapterTest() ? "App server container: " + this.getAppServerInfo() + "\n" : "");
    }

    public Object getCustomValue(Object key) {
        return this.customContext.get(key);
    }

    public void setCustomValue(Object key, Object value) {
        this.customContext.put(key, value);
    }
}

