/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.arquillian.h2;

import java.sql.SQLException;
import org.h2.tools.Server;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;
import org.jboss.logging.Logger;

public class H2TestEnricher {
    protected final Logger log = Logger.getLogger(this.getClass());
    boolean runH2 = Boolean.parseBoolean(System.getProperty("run.h2", "false"));
    private Server server = null;

    public void startH2(@Observes(precedence=2) BeforeSuite event) throws SQLException {
        if (this.runH2) {
            this.log.info((Object)"Starting H2 database.");
            this.server = Server.createTcpServer((String[])new String[0]);
            this.server.start();
            this.log.info((Object)String.format("URL: %s", this.server.getURL()));
        }
    }

    public void stopH2(@Observes(precedence=-2) AfterSuite event) {
        if (this.runH2 && this.server.isRunning(false)) {
            this.log.info((Object)"Stopping H2 database.");
            this.server.stop();
            assert (!this.server.isRunning(false));
        }
    }
}

