/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.auth.page;

import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.testsuite.auth.page.AuthServer;
import org.keycloak.testsuite.auth.page.login.PageWithLoginUrl;

public class AuthRealm
extends AuthServer
implements PageWithLoginUrl {
    public static final String AUTH_REALM = "authRealm";
    public static final String MASTER = "master";
    public static final String TEST = "test";
    public static final String DEMO = "demo";
    public static final String EXAMPLE = "example";
    public static final String SAMLDEMO = "saml-demo";
    public static final String SAMLSERVLETDEMO = "demo";
    public static final String ADMIN = "admin";

    public AuthRealm() {
        this.setUriParameter(AUTH_REALM, MASTER);
    }

    @Override
    public UriBuilder createUriBuilder() {
        return super.createUriBuilder().path("realms/{authRealm}");
    }

    public void setAuthRealm(String authRealm) {
        this.setUriParameter(AUTH_REALM, authRealm);
    }

    public void setAuthRealm(AuthRealm authRealm) {
        this.setUriParameter(AUTH_REALM, authRealm.getAuthRealm());
    }

    public String getAuthRealm() {
        return (String)this.getUriParameter(AUTH_REALM);
    }

    @Override
    public URI getOIDCLoginUrl() {
        return OIDCLoginProtocolService.authUrl((UriBuilder)UriBuilder.fromPath((String)this.getAuthRoot())).build(new Object[]{this.getAuthRealm()});
    }

    public URI getOIDCLogoutUrl() {
        return OIDCLoginProtocolService.logoutUrl((UriBuilder)UriBuilder.fromPath((String)this.getAuthRoot())).build(new Object[]{this.getAuthRealm()});
    }
}

