/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.auth.page.account;

import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.testsuite.auth.page.account.AccountManagement;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class Applications
extends AccountManagement {
    public static final String XPATH_APP_TABLE = "//table[./thead[//td[text()='Application']]]";
    @FindBy(xpath="//table[./thead[//td[text()='Application']]]")
    protected WebElement appTable;
    @FindBy(xpath="//table[./thead[//td[text()='Application']]]//tr")
    private List<WebElement> applicationRows;

    @Override
    public UriBuilder createUriBuilder() {
        return super.createUriBuilder().path("applications");
    }

    public boolean containsApplication(String application) {
        return this.getRowForLinkText(application) != null;
    }

    public void clickApplication(String application) {
        WebElement row = this.getRowForLinkText(application);
        if (row == null) {
            this.log.error((Object)("Application: " + application + " doesn't exist"));
            throw new IllegalArgumentException("Application: " + application + " doesn't exist");
        }
        row.findElement(By.xpath((String)".//a")).click();
    }

    public void revokeGrantForApplication(String application) {
        WebElement row = this.getRowForLinkText(application);
        if (row == null) {
            this.log.error((Object)("Application: " + application + " doesn't exist"));
            throw new IllegalArgumentException("Application: " + application + " doesn't exist");
        }
        row.findElement(By.xpath((String)("//button[@id='revoke-" + application + "']"))).click();
    }

    private WebElement getRowForLinkText(String appLink) {
        for (WebElement appRow : this.applicationRows) {
            if (!appRow.findElement(By.xpath((String)".//td")).getText().equals(appLink)) continue;
            return appRow;
        }
        return null;
    }
}

