/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import org.keycloak.testsuite.pages.AbstractPage;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class LoginPasswordResetPage
extends AbstractPage {
    @FindBy(id="username")
    private WebElement usernameInput;
    @FindBy(css="input[type=\"submit\"]")
    private WebElement submitButton;
    @FindBy(className="alert-success")
    private WebElement emailSuccessMessage;
    @FindBy(className="alert-error")
    private WebElement emailErrorMessage;
    @FindBy(partialLinkText="Back to Login")
    private WebElement backToLogin;

    public void changePassword(String username) {
        this.usernameInput.sendKeys(new CharSequence[]{username});
        this.submitButton.click();
    }

    @Override
    public boolean isCurrent() {
        return this.driver.getTitle().equals("Forgot Your Password?");
    }

    @Override
    public void open() {
        throw new UnsupportedOperationException();
    }

    public String getSuccessMessage() {
        return this.emailSuccessMessage != null ? this.emailSuccessMessage.getText() : null;
    }

    public String getErrorMessage() {
        return this.emailErrorMessage != null ? this.emailErrorMessage.getText() : null;
    }

    public void backToLogin() {
        this.backToLogin.click();
    }
}

