/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.util.Map;
import java.util.Properties;
import org.junit.rules.ExternalResource;
import org.keycloak.testsuite.util.LDAPTestConfiguration;
import org.keycloak.util.ldap.LDAPEmbeddedServer;

public class LDAPRule
extends ExternalResource {
    public static final String LDAP_CONNECTION_PROPERTIES_LOCATION = "classpath:ldap/ldap-connection.properties";
    private static final String PROPERTY_ENABLE_SSL = "enableSSL";
    private static final String PROPERTY_KEYSTORE_FILE = "keystoreFile";
    private static final String PRIVATE_KEY = "keystore/keycloak.jks";
    private static final String PROPERTY_CERTIFICATE_PASSWORD = "certificatePassword";
    protected LDAPTestConfiguration ldapTestConfiguration;
    protected LDAPEmbeddedServer ldapEmbeddedServer;

    protected void before() throws Throwable {
        String connectionPropsLocation = this.getConnectionPropertiesLocation();
        this.ldapTestConfiguration = LDAPTestConfiguration.readConfiguration(connectionPropsLocation);
        if (this.ldapTestConfiguration.isStartEmbeddedLdapServer()) {
            this.ldapEmbeddedServer = this.createServer();
            this.ldapEmbeddedServer.init();
            this.ldapEmbeddedServer.start();
        }
    }

    protected void after() {
        try {
            if (this.ldapEmbeddedServer != null) {
                this.ldapEmbeddedServer.stop();
                this.ldapEmbeddedServer = null;
                this.ldapTestConfiguration = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error tearDown Embedded LDAP server.", e);
        }
    }

    protected String getConnectionPropertiesLocation() {
        return LDAP_CONNECTION_PROPERTIES_LOCATION;
    }

    protected LDAPEmbeddedServer createServer() {
        Properties defaultProperties = new Properties();
        defaultProperties.setProperty("ldap.dsf", "mem");
        defaultProperties.setProperty("ldap.ldif", "classpath:ldap/users.ldif");
        defaultProperties.setProperty("connectionUrl", "ldaps://localhost:10636");
        defaultProperties.setProperty("ldap.port", "10636");
        defaultProperties.setProperty(PROPERTY_ENABLE_SSL, "true");
        defaultProperties.setProperty(PROPERTY_CERTIFICATE_PASSWORD, "secret");
        defaultProperties.setProperty(PROPERTY_KEYSTORE_FILE, ((Object)((Object)this)).getClass().getClassLoader().getResource(PRIVATE_KEY).getFile());
        return new LDAPEmbeddedServer(defaultProperties);
    }

    public Map<String, String> getConfig() {
        return this.ldapTestConfiguration.getLDAPConfig();
    }

    public int getSleepTime() {
        return this.ldapTestConfiguration.getSleepTime();
    }
}

