/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket;

import javax.websocket.Session;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.controller.api.model.events.ServerInstanceConnected;
import org.kie.server.controller.api.model.events.ServerInstanceUpdated;
import org.kie.server.controller.api.model.runtime.ServerInstance;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.impl.KieServerControllerImpl;
import org.kie.server.controller.websocket.WebSocketSessionManager;
import org.kie.server.controller.websocket.common.WebSocketUtils;
import org.kie.server.controller.websocket.common.handlers.InternalMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectedKieServerHandler
implements InternalMessageHandler {
    private static final Logger logger = LoggerFactory.getLogger(ConnectedKieServerHandler.class);
    private WebSocketSessionManager manager;
    private Session session;
    private KieServerControllerImpl controller;
    private String serverId;
    private KieServerInfo serverInfo;

    public ConnectedKieServerHandler(WebSocketSessionManager manager, Session session, KieServerControllerImpl controller, String serverId) {
        this.manager = manager;
        this.session = session;
        this.controller = controller;
        this.serverId = serverId;
    }

    public String onMessage(String message) {
        this.serverInfo = (KieServerInfo)WebSocketUtils.unmarshal((String)message, KieServerInfo.class);
        logger.debug("Server info {}", (Object)this.serverInfo);
        KieServerSetup serverSetup = this.controller.connect(this.serverInfo);
        if (serverSetup.hasNoErrors()) {
            this.manager.addSession(this.serverInfo, this.session);
            logger.info("Server with id '{}' connected", (Object)this.serverId);
        } else {
            logger.warn("Server with id '{}' failed to connect", (Object)this.serverId);
        }
        return WebSocketUtils.marshal((Object)serverSetup);
    }

    public void afterResponseSent() {
        ServerTemplate serverTemplate = this.controller.getTemplateStorage().load(this.serverInfo.getServerId());
        ServerInstanceKey serverInstanceKey = serverTemplate.getServerInstanceKeys().stream().filter(server -> server.getUrl().equals(this.serverInfo.getLocation())).findFirst().get();
        ServerInstance serverInstance = new ServerInstance();
        serverInstance.setServerName(serverInstanceKey.getServerName());
        serverInstance.setServerTemplateId(serverInstanceKey.getServerTemplateId());
        serverInstance.setServerInstanceId(serverInstanceKey.getServerInstanceId());
        serverInstance.setUrl(serverInstanceKey.getUrl());
        this.controller.getNotificationService().notify(new ServerInstanceUpdated(serverInstance));
        this.controller.getNotificationService().notify(new ServerInstanceConnected(serverInstance));
    }
}

