/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket.management;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.ServiceLoader;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.Wrapped;
import org.kie.server.controller.api.commands.KieServerControllerDescriptorCommand;
import org.kie.server.controller.api.model.KieServerControllerServiceResponse;
import org.kie.server.controller.api.service.NotificationService;
import org.kie.server.controller.api.service.NotificationServiceFactory;
import org.kie.server.controller.api.service.PersistingServerTemplateStorageService;
import org.kie.server.controller.api.service.RuleCapabilitiesService;
import org.kie.server.controller.api.service.RuntimeManagementService;
import org.kie.server.controller.api.service.SpecManagementService;
import org.kie.server.controller.api.storage.KieServerTemplateStorage;
import org.kie.server.controller.impl.service.RuleCapabilitiesServiceImpl;
import org.kie.server.controller.impl.service.RuntimeManagementServiceImpl;
import org.kie.server.controller.impl.service.SpecManagementServiceImpl;
import org.kie.server.controller.websocket.management.KieServerMgmtCommandService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerMgmtCommandServiceImpl
implements KieServerMgmtCommandService {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieServerMgmtCommandServiceImpl.class);
    private SpecManagementServiceImpl specManagementService = new SpecManagementServiceImpl();
    private RuntimeManagementServiceImpl runtimeManagementService = new RuntimeManagementServiceImpl();
    private RuleCapabilitiesServiceImpl ruleCapabilitiesService = new RuleCapabilitiesServiceImpl();
    private static KieServerMgmtCommandServiceImpl INSTANCE = new KieServerMgmtCommandServiceImpl();

    public static KieServerMgmtCommandServiceImpl getInstance() {
        return INSTANCE;
    }

    private KieServerMgmtCommandServiceImpl() {
        ServiceLoader<PersistingServerTemplateStorageService> storageServices = ServiceLoader.load(PersistingServerTemplateStorageService.class);
        if (storageServices != null && storageServices.iterator().hasNext()) {
            PersistingServerTemplateStorageService storageService = storageServices.iterator().next();
            this.setTemplateStorage(storageService.getTemplateStorage());
        } else {
            LOGGER.debug("No server template storage defined. Default storage: InMemoryKieServerTemplateStorage will be used");
        }
        ServiceLoader<NotificationServiceFactory> notificationServiceLoader = ServiceLoader.load(NotificationServiceFactory.class);
        if (notificationServiceLoader != null && notificationServiceLoader.iterator().hasNext()) {
            NotificationService notificationService = notificationServiceLoader.iterator().next().getNotificationService();
            this.setNotificationService(notificationService);
        } else {
            LOGGER.warn("Notification service not defined. Default notification: LoggingNotificationService will be used");
        }
    }

    public void setTemplateStorage(KieServerTemplateStorage templateStorage) {
        this.specManagementService.setTemplateStorage(templateStorage);
        this.runtimeManagementService.setTemplateStorage(templateStorage);
        this.ruleCapabilitiesService.setTemplateStorage(templateStorage);
        LOGGER.debug("Server template storage for kie server controller is {}", (Object)templateStorage.toString());
    }

    public void setNotificationService(NotificationService notificationService) {
        this.specManagementService.setNotificationService(notificationService);
        this.ruleCapabilitiesService.setNotificationService(notificationService);
        LOGGER.debug("Notification service for kie server controller is {}", (Object)notificationService.toString());
    }

    @Override
    public KieServerControllerServiceResponse executeCommand(KieServerControllerDescriptorCommand command) {
        if (command == null) {
            return new KieServerControllerServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Command can not be null");
        }
        try {
            Object result = null;
            SpecManagementServiceImpl handler = null;
            if (SpecManagementService.class.getName().equals(command.getService())) {
                handler = this.specManagementService;
            } else if (RuntimeManagementService.class.getName().equals(command.getService())) {
                handler = this.runtimeManagementService;
            } else if (RuleCapabilitiesService.class.getName().equals(command.getService())) {
                handler = this.ruleCapabilitiesService;
            } else {
                throw new IllegalStateException("Unable to find handler for " + command.getService() + " service");
            }
            LOGGER.debug("Service handler: {}", (Object)handler);
            LOGGER.debug("Command arguments size: {}", (Object)command.getArguments().size());
            ArrayList<Object> arguments = new ArrayList<Object>();
            for (Object arg : command.getArguments()) {
                LOGGER.debug("Before :: Argument with type {} and value {}", arg == null ? "null" : arg.getClass(), arg);
                if (arg instanceof Wrapped) {
                    arg = ((Wrapped)arg).unwrap();
                }
                LOGGER.debug("After :: Argument with type {} and value {}", arg == null ? "null" : arg.getClass(), arg);
                arguments.add(arg);
            }
            LOGGER.debug("About to execute {} operation on {} with args {}", new Object[]{command.getMethod(), handler, arguments});
            result = MethodUtils.invokeMethod((Object)handler, (String)command.getMethod(), (Object[])arguments.toArray());
            LOGGER.debug("Handler {} returned response {}", (Object)handler, result);
            return new KieServerControllerServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "", result);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("Failed to invoke service method", (Throwable)e);
            return new KieServerControllerServiceResponse(KieServiceResponse.ResponseType.FAILURE, e.getTargetException().getMessage());
        }
        catch (Throwable e) {
            LOGGER.error("Error while processing {} command", (Object)command, (Object)e);
            return new KieServerControllerServiceResponse(KieServiceResponse.ResponseType.FAILURE, e.getMessage());
        }
    }
}

