/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardsoftdouble;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.buildin.hardsoftdouble.HardSoftDoubleScore;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;

public class HardSoftDoubleScoreHolder
extends AbstractScoreHolder<HardSoftDoubleScore> {
    protected final Map<Rule, BiConsumer<RuleContext, Double>> matchExecutorByNumberMap = new LinkedHashMap<Rule, BiConsumer<RuleContext, Double>>();
    protected final Map<Rule, BiConsumer<RuleContext, HardSoftDoubleScore>> matchExecutorByScoreMap = new LinkedHashMap<Rule, BiConsumer<RuleContext, HardSoftDoubleScore>>();
    protected double hardScore;
    protected double softScore;

    public HardSoftDoubleScoreHolder(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled, HardSoftDoubleScore.ZERO);
    }

    public double getHardScore() {
        return this.hardScore;
    }

    public double getSoftScore() {
        return this.softScore;
    }

    @Override
    public void configureConstraintWeight(Rule rule, HardSoftDoubleScore constraintWeight) {
        super.configureConstraintWeight(rule, constraintWeight);
        BiConsumer<RuleContext, Double> matchExecutor = constraintWeight.equals(HardSoftDoubleScore.ZERO) ? (kcontext, matchWeight) -> {} : (constraintWeight.getSoftScore() == 0.0 ? (kcontext, matchWeight) -> this.addHardConstraintMatch((RuleContext)kcontext, constraintWeight.getHardScore() * matchWeight) : (constraintWeight.getHardScore() == 0.0 ? (kcontext, matchWeight) -> this.addSoftConstraintMatch((RuleContext)kcontext, constraintWeight.getSoftScore() * matchWeight) : (kcontext, matchWeight) -> this.addMultiConstraintMatch((RuleContext)kcontext, constraintWeight.getHardScore() * matchWeight, constraintWeight.getSoftScore() * matchWeight)));
        this.matchExecutorByNumberMap.put(rule, matchExecutor);
        this.matchExecutorByScoreMap.put(rule, (kcontext, weightMultiplier) -> this.addMultiConstraintMatch((RuleContext)kcontext, constraintWeight.getHardScore() * weightMultiplier.getHardScore(), constraintWeight.getSoftScore() * weightMultiplier.getSoftScore()));
    }

    public void penalize(RuleContext kcontext) {
        this.impactScore(kcontext, -1.0);
    }

    public void penalize(RuleContext kcontext, double weightMultiplier) {
        this.impactScore(kcontext, -weightMultiplier);
    }

    public void penalize(RuleContext kcontext, double hardWeightMultiplier, double softWeightMultiplier) {
        this.impactScore(kcontext, -hardWeightMultiplier, -softWeightMultiplier);
    }

    public void reward(RuleContext kcontext) {
        this.impactScore(kcontext, 1.0);
    }

    public void reward(RuleContext kcontext, double weightMultiplier) {
        this.impactScore(kcontext, weightMultiplier);
    }

    public void reward(RuleContext kcontext, double hardWeightMultiplier, double softWeightMultiplier) {
        this.impactScore(kcontext, hardWeightMultiplier, softWeightMultiplier);
    }

    @Override
    public void impactScore(RuleContext kcontext) {
        this.impactScore(kcontext, 1);
    }

    private void impactScore(RuleContext kcontext, double weightMultiplier) {
        Rule rule = kcontext.getRule();
        BiConsumer<RuleContext, Double> matchExecutor = this.matchExecutorByNumberMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, weightMultiplier);
    }

    private void impactScore(RuleContext kcontext, double hardWeightMultiplier, double softWeightMultiplier) {
        Rule rule = kcontext.getRule();
        BiConsumer<RuleContext, HardSoftDoubleScore> matchExecutor = this.matchExecutorByScoreMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, HardSoftDoubleScore.of(hardWeightMultiplier, softWeightMultiplier));
    }

    public void addHardConstraintMatch(RuleContext kcontext, double hardWeight) {
        this.hardScore += hardWeight;
        this.registerConstraintMatch(kcontext, () -> this.hardScore -= hardWeight, () -> HardSoftDoubleScore.of(hardWeight, 0.0));
    }

    public void addSoftConstraintMatch(RuleContext kcontext, double softWeight) {
        this.softScore += softWeight;
        this.registerConstraintMatch(kcontext, () -> this.softScore -= softWeight, () -> HardSoftDoubleScore.of(0.0, softWeight));
    }

    public void addMultiConstraintMatch(RuleContext kcontext, double hardWeight, double softWeight) {
        this.hardScore += hardWeight;
        this.softScore += softWeight;
        this.registerConstraintMatch(kcontext, () -> {
            this.hardScore -= hardWeight;
            this.softScore -= softWeight;
        }, () -> HardSoftDoubleScore.of(hardWeight, softWeight));
    }

    @Override
    public HardSoftDoubleScore extractScore(int initScore) {
        return HardSoftDoubleScore.ofUninitialized(initScore, this.hardScore, this.softScore);
    }
}

