/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.simpledouble;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.buildin.simpledouble.SimpleDoubleScore;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;

public class SimpleDoubleScoreHolder
extends AbstractScoreHolder<SimpleDoubleScore> {
    protected final Map<Rule, BiConsumer<RuleContext, Double>> matchExecutorByNumberMap = new LinkedHashMap<Rule, BiConsumer<RuleContext, Double>>();
    protected double score;

    public SimpleDoubleScoreHolder(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled, SimpleDoubleScore.ZERO);
    }

    public double getScore() {
        return this.score;
    }

    @Override
    public void configureConstraintWeight(Rule rule, SimpleDoubleScore constraintWeight) {
        super.configureConstraintWeight(rule, constraintWeight);
        BiConsumer<RuleContext, Double> matchExecutor = constraintWeight.equals(SimpleDoubleScore.ZERO) ? (kcontext, matchWeight) -> {} : (kcontext, matchWeight) -> this.addConstraintMatch((RuleContext)kcontext, constraintWeight.getScore() * matchWeight);
        this.matchExecutorByNumberMap.put(rule, matchExecutor);
    }

    public void penalize(RuleContext kcontext) {
        this.impactScore(kcontext, -1.0);
    }

    public void penalize(RuleContext kcontext, double weightMultiplier) {
        this.impactScore(kcontext, -weightMultiplier);
    }

    public void reward(RuleContext kcontext) {
        this.impactScore(kcontext, 1.0);
    }

    public void reward(RuleContext kcontext, double weightMultiplier) {
        this.impactScore(kcontext, weightMultiplier);
    }

    @Override
    public void impactScore(RuleContext kcontext) {
        this.impactScore(kcontext, 1.0);
    }

    private void impactScore(RuleContext kcontext, double weightMultiplier) {
        Rule rule = kcontext.getRule();
        BiConsumer<RuleContext, Double> matchExecutor = this.matchExecutorByNumberMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, weightMultiplier);
    }

    public void addConstraintMatch(RuleContext kcontext, double weight) {
        this.score += weight;
        this.registerConstraintMatch(kcontext, () -> this.score -= weight, () -> SimpleDoubleScore.of(weight));
    }

    @Override
    public SimpleDoubleScore extractScore(int initScore) {
        return SimpleDoubleScore.ofUninitialized(initScore, this.score);
    }
}

