/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools;

import java.util.Map;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.api.score.holder.ScoreHolder;
import org.optaplanner.core.impl.score.stream.ConstraintSession;

public class DroolsConstraintSession<Solution_>
implements ConstraintSession<Solution_> {
    private final boolean constraintMatchEnabled;
    private final KieSession kieSession;
    private final ScoreHolder scoreHolder;

    public DroolsConstraintSession(boolean constraintMatchEnabled, KieSession kieSession, ScoreHolder scoreHolder) {
        this.constraintMatchEnabled = constraintMatchEnabled;
        this.kieSession = kieSession;
        this.scoreHolder = scoreHolder;
    }

    @Override
    public void insert(Object fact) {
        this.kieSession.insert(fact);
    }

    @Override
    public void update(Object fact) {
        FactHandle factHandle = this.kieSession.getFactHandle(fact);
        this.kieSession.update(factHandle, fact);
    }

    @Override
    public void retract(Object fact) {
        FactHandle factHandle = this.kieSession.getFactHandle(fact);
        this.kieSession.delete(factHandle);
    }

    @Override
    public Score<?> calculateScore(int initScore) {
        this.kieSession.fireAllRules();
        return this.scoreHolder.extractScore(initScore);
    }

    @Override
    public Map<String, ConstraintMatchTotal> getConstraintMatchTotalMap() {
        this.kieSession.fireAllRules();
        return this.scoreHolder.getConstraintMatchTotalMap();
    }

    @Override
    public Map<Object, Indictment> getIndictmentMap() {
        this.kieSession.fireAllRules();
        return this.scoreHolder.getIndictmentMap();
    }

    @Override
    public void close() {
        this.kieSession.dispose();
    }
}

