/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kie.api.KieBase;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.KieSession;
import org.kie.internal.event.rule.RuleEventListener;
import org.kie.internal.event.rule.RuleEventManager;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.drools.OptaPlannerRuleEventListener;
import org.optaplanner.core.impl.score.stream.ConstraintSession;
import org.optaplanner.core.impl.score.stream.ConstraintSessionFactory;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintSession;
import org.optaplanner.core.impl.score.stream.drools.common.FactTuple;

public class DroolsConstraintSessionFactory<Solution_>
implements ConstraintSessionFactory<Solution_> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final KieBase kieBase;
    private final Map<Rule, DroolsConstraint<Solution_>> constraints;

    public DroolsConstraintSessionFactory(SolutionDescriptor<Solution_> solutionDescriptor, KieBase kieBase, List<DroolsConstraint<Solution_>> constraintList) {
        this.solutionDescriptor = solutionDescriptor;
        this.kieBase = kieBase;
        this.constraints = constraintList.stream().collect(Collectors.toMap(constraint -> kieBase.getRule(constraint.getConstraintPackage(), constraint.getConstraintName()), Function.identity()));
    }

    @Override
    public ConstraintSession<Solution_> buildSession(boolean constraintMatchEnabled, Solution_ workingSolution) {
        ScoreDefinition scoreDefinition = this.solutionDescriptor.getScoreDefinition();
        AbstractScoreHolder scoreHolder = (AbstractScoreHolder)scoreDefinition.buildScoreHolder(constraintMatchEnabled);
        scoreHolder.setJustificationListConverter((justificationList, rule) -> DroolsConstraintSessionFactory.matchJustificationsToOutput((List)justificationList, this.constraints.get(rule).getExpectedJustificationTypes()));
        this.constraints.forEach((rule, constraint) -> scoreHolder.configureConstraintWeight((Rule)rule, constraint.extractConstraintWeight(workingSolution)));
        KieSession kieSession = this.kieBase.newKieSession();
        ((RuleEventManager)kieSession).addEventListener((RuleEventListener)new OptaPlannerRuleEventListener());
        kieSession.setGlobal("scoreHolder", (Object)scoreHolder);
        return new DroolsConstraintSession(constraintMatchEnabled, kieSession, scoreHolder);
    }

    private static List<Object> matchJustificationsToOutput(List<Object> justificationList, Class ... expectedTypes) {
        Class expectedType;
        int i;
        if (expectedTypes.length == 0) {
            throw new IllegalStateException("Impossible: there are no 0-cardinality constraint streams.");
        }
        Object[] matching = new Object[expectedTypes.length];
        for (i = 0; i < expectedTypes.length; ++i) {
            expectedType = expectedTypes[i];
            if (Objects.equals(expectedType, Object.class)) continue;
            Object match = justificationList.stream().filter(j -> expectedType.isAssignableFrom(j.getClass())).findFirst().orElseThrow(() -> new IllegalStateException("Impossible: no justification of type (" + expectedType + ")."));
            justificationList.remove(match);
            matching[i] = match;
        }
        for (i = 0; i < expectedTypes.length; ++i) {
            if (matching[i] != null) continue;
            Object match = justificationList.stream().findFirst().orElseThrow(() -> new IllegalStateException("Impossible: there are no more constraint matches."));
            justificationList.remove(match);
            matching[i] = match;
        }
        if (matching.length > 1) {
            return Arrays.asList(matching);
        }
        Object item = matching[0];
        expectedType = expectedTypes[0];
        if (FactTuple.class.isAssignableFrom(expectedType)) {
            return ((FactTuple)item).asList();
        }
        return Collections.singletonList(item);
    }
}

