/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.SignatureAttribute;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;

public class PersistentAttributesHelper {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(PersistentAttributesHelper.class);

    private PersistentAttributesHelper() {
    }

    public static boolean hasAnnotation(CtField attribute, Class<? extends Annotation> annotation) {
        return PersistentAttributesHelper.getAnnotation(attribute, annotation) != null;
    }

    public static boolean hasAnnotation(CtClass ctClass, String attributeName, Class<? extends Annotation> annotation) {
        return PersistentAttributesHelper.getAnnotation(ctClass, attributeName, annotation) != null;
    }

    public static <T extends Annotation> T getAnnotation(CtField attribute, Class<T> annotation) {
        return PersistentAttributesHelper.getAnnotation(attribute.getDeclaringClass(), attribute.getName(), annotation);
    }

    public static <T extends Annotation> T getAnnotation(CtClass ctClass, String attributeName, Class<T> annotation) {
        T found;
        AccessType classAccessType = PersistentAttributesHelper.getAccessTypeOrNull(ctClass);
        CtField field = PersistentAttributesHelper.findFieldOrNull(ctClass, attributeName);
        CtMethod getter = PersistentAttributesHelper.findGetterOrNull(ctClass, attributeName);
        if (classAccessType == AccessType.FIELD || field != null && PersistentAttributesHelper.getAccessTypeOrNull((CtMember)field) == AccessType.FIELD) {
            return field == null ? null : (T)PersistentAttributesHelper.getAnnotationOrNull((CtMember)field, annotation);
        }
        if (classAccessType == AccessType.PROPERTY || getter != null && PersistentAttributesHelper.getAccessTypeOrNull((CtMember)getter) == AccessType.PROPERTY) {
            return getter == null ? null : (T)PersistentAttributesHelper.getAnnotationOrNull((CtMember)getter, annotation);
        }
        T t = found = getter == null ? null : (T)PersistentAttributesHelper.getAnnotationOrNull((CtMember)getter, annotation);
        if (found == null && field != null) {
            return PersistentAttributesHelper.getAnnotationOrNull((CtMember)field, annotation);
        }
        return found;
    }

    private static <T extends Annotation> T getAnnotationOrNull(CtMember ctMember, Class<T> annotation) {
        try {
            if (ctMember.hasAnnotation(annotation)) {
                return (T)((Annotation)annotation.cast(ctMember.getAnnotation(annotation)));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private static AccessType getAccessTypeOrNull(CtMember ctMember) {
        Access access = PersistentAttributesHelper.getAnnotationOrNull(ctMember, Access.class);
        return access == null ? null : access.value();
    }

    private static AccessType getAccessTypeOrNull(CtClass ctClass) {
        try {
            if (ctClass.hasAnnotation(Access.class)) {
                return ((Access)ctClass.getAnnotation(Access.class)).value();
            }
            CtClass extendsClass = ctClass.getSuperclass();
            return extendsClass == null ? null : PersistentAttributesHelper.getAccessTypeOrNull(extendsClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    private static CtField findFieldOrNull(CtClass ctClass, String propertyName) {
        if (ctClass == null) {
            return null;
        }
        try {
            return ctClass.getField(propertyName);
        }
        catch (NotFoundException nsfe) {
            try {
                return PersistentAttributesHelper.findFieldOrNull(ctClass.getSuperclass(), propertyName);
            }
            catch (NotFoundException e) {
                return null;
            }
        }
    }

    private static CtMethod findGetterOrNull(CtClass ctClass, String propertyName) {
        if (ctClass == null) {
            return null;
        }
        CtMethod method = PersistentAttributesHelper.getterOrNull(ctClass, propertyName);
        if (method != null) {
            return method;
        }
        try {
            method = PersistentAttributesHelper.findGetterOrNull(ctClass.getSuperclass(), propertyName);
            if (method != null) {
                return method;
            }
            for (CtClass interfaceCtClass : ctClass.getInterfaces()) {
                method = PersistentAttributesHelper.getterOrNull(interfaceCtClass, propertyName);
                if (method == null) continue;
                return method;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return null;
    }

    private static CtMethod getterOrNull(CtClass containerClass, String propertyName) {
        for (CtMethod method : containerClass.getDeclaredMethods()) {
            String testOldMethod;
            String testStdMethod;
            try {
                if (method.isEmpty()) continue;
                if (method.getParameterTypes().length != 0) {
                }
            }
            catch (NotFoundException e) {}
            continue;
            String methodName = method.getName();
            if (methodName.startsWith("get")) {
                testStdMethod = Introspector.decapitalize(methodName.substring(3));
                testOldMethod = methodName.substring(3);
                if (testStdMethod.equals(propertyName) || testOldMethod.equals(propertyName)) {
                    return method;
                }
            }
            if (!methodName.startsWith("is")) continue;
            testStdMethod = Introspector.decapitalize(methodName.substring(2));
            testOldMethod = methodName.substring(2);
            if (!testStdMethod.equals(propertyName) && !testOldMethod.equals(propertyName)) continue;
            return method;
        }
        return null;
    }

    public static boolean isPossibleBiDirectionalAssociation(CtField persistentField) {
        return PersistentAttributesHelper.hasAnnotation(persistentField, OneToOne.class) || PersistentAttributesHelper.hasAnnotation(persistentField, OneToMany.class) || PersistentAttributesHelper.hasAnnotation(persistentField, ManyToOne.class) || PersistentAttributesHelper.hasAnnotation(persistentField, ManyToMany.class);
    }

    public static String getMappedBy(CtField persistentField, CtClass targetEntity, EnhancementContext context) throws NotFoundException {
        String local = PersistentAttributesHelper.getMappedByFromAnnotation(persistentField);
        return local.isEmpty() ? PersistentAttributesHelper.getMappedByFromTargetEntity(persistentField, targetEntity, context) : local;
    }

    private static String getMappedByFromAnnotation(CtField persistentField) {
        OneToOne oto = PersistentAttributesHelper.getAnnotation(persistentField, OneToOne.class);
        if (oto != null) {
            return oto.mappedBy();
        }
        OneToMany otm = PersistentAttributesHelper.getAnnotation(persistentField, OneToMany.class);
        if (otm != null) {
            return otm.mappedBy();
        }
        ManyToMany mtm = PersistentAttributesHelper.getAnnotation(persistentField, ManyToMany.class);
        return mtm == null ? "" : mtm.mappedBy();
    }

    private static String getMappedByFromTargetEntity(CtField persistentField, CtClass targetEntity, EnhancementContext context) throws NotFoundException {
        for (CtField f : targetEntity.getDeclaredFields()) {
            if (!context.isPersistentField(f) || !PersistentAttributesHelper.getMappedByFromAnnotation(f).equals(persistentField.getName()) || !PersistentAttributesHelper.isAssignable(persistentField.getDeclaringClass(), PersistentAttributesHelper.inferFieldTypeName(f))) continue;
            log.debugf("mappedBy association for field [%s#%s] is [%s#%s]", new Object[]{persistentField.getDeclaringClass().getName(), persistentField.getName(), targetEntity.getName(), f.getName()});
            return f.getName();
        }
        return "";
    }

    public static CtClass getTargetEntityClass(CtClass managedCtClass, CtField persistentField) throws NotFoundException {
        try {
            OneToOne oto = PersistentAttributesHelper.getAnnotation(persistentField, OneToOne.class);
            OneToMany otm = PersistentAttributesHelper.getAnnotation(persistentField, OneToMany.class);
            ManyToOne mto = PersistentAttributesHelper.getAnnotation(persistentField, ManyToOne.class);
            ManyToMany mtm = PersistentAttributesHelper.getAnnotation(persistentField, ManyToMany.class);
            Class targetClass = null;
            if (oto != null) {
                targetClass = oto.targetEntity();
            }
            if (otm != null) {
                targetClass = otm.targetEntity();
            }
            if (mto != null) {
                targetClass = mto.targetEntity();
            }
            if (mtm != null) {
                targetClass = mtm.targetEntity();
            }
            if (targetClass != null && targetClass != Void.TYPE) {
                return managedCtClass.getClassPool().get(targetClass.getName());
            }
        }
        catch (NotFoundException oto) {
            // empty catch block
        }
        String inferredTypeName = PersistentAttributesHelper.inferTypeName(managedCtClass, persistentField.getName());
        return inferredTypeName == null ? null : managedCtClass.getClassPool().get(inferredTypeName);
    }

    private static String inferTypeName(CtClass ctClass, String attributeName) {
        String found;
        AccessType classAccessType = PersistentAttributesHelper.getAccessTypeOrNull(ctClass);
        CtField field = PersistentAttributesHelper.findFieldOrNull(ctClass, attributeName);
        CtMethod getter = PersistentAttributesHelper.findGetterOrNull(ctClass, attributeName);
        if (classAccessType == AccessType.FIELD || field != null && PersistentAttributesHelper.getAccessTypeOrNull((CtMember)field) == AccessType.FIELD) {
            return field == null ? null : PersistentAttributesHelper.inferFieldTypeName(field);
        }
        if (classAccessType == AccessType.PROPERTY || getter != null && PersistentAttributesHelper.getAccessTypeOrNull((CtMember)getter) == AccessType.PROPERTY) {
            return getter == null ? null : PersistentAttributesHelper.inferMethodTypeName(getter);
        }
        String string = found = getter == null ? null : PersistentAttributesHelper.inferMethodTypeName(getter);
        if (found == null && field != null) {
            return PersistentAttributesHelper.inferFieldTypeName(field);
        }
        return found;
    }

    private static String inferFieldTypeName(CtField field) {
        try {
            if (field.getFieldInfo2().getAttribute("Signature") == null) {
                return field.getType().getName();
            }
            return PersistentAttributesHelper.inferGenericTypeName(field.getType(), SignatureAttribute.toTypeSignature((String)field.getGenericSignature()));
        }
        catch (BadBytecode ignore) {
            return null;
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    private static String inferMethodTypeName(CtMethod method) {
        try {
            if (method.getMethodInfo2().getAttribute("Signature") == null) {
                return method.getReturnType().getName();
            }
            return PersistentAttributesHelper.inferGenericTypeName(method.getReturnType(), SignatureAttribute.toMethodSignature((String)method.getGenericSignature()).getReturnType());
        }
        catch (BadBytecode ignore) {
            return null;
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    private static String inferGenericTypeName(CtClass ctClass, SignatureAttribute.Type genericSignature) {
        if (PersistentAttributesHelper.isAssignable(ctClass, Collection.class.getName())) {
            return ((SignatureAttribute.ClassType)genericSignature).getTypeArguments()[0].getType().jvmTypeName();
        }
        if (PersistentAttributesHelper.isAssignable(ctClass, Map.class.getName())) {
            return ((SignatureAttribute.ClassType)genericSignature).getTypeArguments()[1].getType().jvmTypeName();
        }
        return ctClass.getName();
    }

    public static boolean isAssignable(CtClass thisCtClass, String targetClassName) {
        if (thisCtClass == null) {
            return false;
        }
        if (thisCtClass.getName().equals(targetClassName)) {
            return true;
        }
        try {
            if (PersistentAttributesHelper.isAssignable(thisCtClass.getSuperclass(), targetClassName)) {
                return true;
            }
            for (CtClass interfaceCtClass : thisCtClass.getInterfaces()) {
                if (!PersistentAttributesHelper.isAssignable(interfaceCtClass, targetClassName)) continue;
                return true;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isAssignable(CtField thisCtField, String targetClassName) {
        try {
            return PersistentAttributesHelper.isAssignable(thisCtField.getType(), targetClassName);
        }
        catch (NotFoundException notFoundException) {
            return false;
        }
    }
}

